/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.train;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ctakes.assertion.eval.AssertionEvaluation;
import org.apache.ctakes.assertion.util.AssertionConst;

public class PolarityDomainAdaptationTrain {
    protected static final String SHARP_TRAIN = "/projects/data/assertion/data/preprocessed_data/sharp/train";
    protected static final String I2B2_TRAIN = "/projects/data/assertion/data/preprocessed_data/i2b2/train";
    protected static final String MIPACQ_TRAIN = "/projects/data/assertion/data/preprocessed_data/mipacq/train";
    protected static final String NEGEX_TRAIN = "/projects/data/assertion/data/preprocessed_data/negex";
    public static final String SHARP_FEDA = "../ctakes-assertion-res/resources/model/sharptrain-feda";
    protected static final String I2B2_FEDA = "../ctakes-assertion-res/resources/model/i2b2train-feda";
    protected static final String MIPACQ_FEDA = "../ctakes-assertion-res/resources/model/mipacqtrain-feda";
    protected static final String NEGEX_FEDA = "../ctakes-assertion-res/resources/model/negextest-feda";
    protected static final String SHARP_I2B2_FEDA = "../ctakes-assertion-res/resources/model/sharptrain+i2b2train-feda";
    protected static final String SHARP_MIPACQ_FEDA = "../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain-feda";
    protected static final String SHARP_NEGEX_FEDA = "../ctakes-assertion-res/resources/model/sharptrain+negextest-feda";
    protected static final String I2B2_MIPACQ_NEGEX_FEDA = "../ctakes-assertion-res/resources/model/i2b2train+mipacqtrain+negextest-feda";
    protected static final String SHARP_I2B2_MIPACQ_FEDA = "../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain-feda";
    protected static final String SHARP_MIPACQ_NEGEX_FEDA = "../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain+negextest-feda";
    protected static final String SHARP_I2B2_NEGEX_FEDA = "../ctakes-assertion-res/resources/model/sharptrain+i2b2train+negextest-feda";
    protected static final String SHARP_I2B2_MIPACQ_NEGEX_FEDA = "../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex-feda";
    public static BiMap<String, String> trainGrid = HashBiMap.create();

    public static void main(String[] args) throws Exception {
        String attribute = "polarity";
        for (Map.Entry oneTrain : trainGrid.entrySet()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("--train-dir");
            params.add((String)oneTrain.getKey());
            params.add("--models-dir");
            params.add((String)oneTrain.getValue());
            params.add("--train-only");
            params.add("--feature-selection");
            params.add(Float.toString(1.0E-12f));
            params.add("--feda");
            for (String ignoreAttribute : AssertionConst.allAnnotationTypes) {
                if (ignoreAttribute.equals(attribute)) continue;
                if (ignoreAttribute.equals("historyOf")) {
                    ignoreAttribute = ignoreAttribute.substring(0, ignoreAttribute.length() - 2);
                }
                params.add("--ignore-" + ignoreAttribute);
            }
            String[] paramList = params.toArray(new String[0]);
            AssertionEvaluation.main(paramList);
        }
    }

    static {
        trainGrid.put((Object)SHARP_TRAIN, (Object)SHARP_FEDA);
        trainGrid.put((Object)I2B2_TRAIN, (Object)I2B2_FEDA);
        trainGrid.put((Object)MIPACQ_TRAIN, (Object)MIPACQ_FEDA);
        trainGrid.put((Object)NEGEX_TRAIN, (Object)NEGEX_FEDA);
        trainGrid.put((Object)"/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/i2b2/train", (Object)SHARP_I2B2_FEDA);
        trainGrid.put((Object)"/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/mipacq/train", (Object)SHARP_MIPACQ_FEDA);
        trainGrid.put((Object)"/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/negex", (Object)SHARP_NEGEX_FEDA);
        trainGrid.put((Object)"/projects/data/assertion/data/preprocessed_data/i2b2/train:/projects/data/assertion/data/preprocessed_data/mipacq/train:/projects/data/assertion/data/preprocessed_data/negex", (Object)I2B2_MIPACQ_NEGEX_FEDA);
        trainGrid.put((Object)"/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/i2b2/train:/projects/data/assertion/data/preprocessed_data/mipacq/train", (Object)SHARP_I2B2_MIPACQ_FEDA);
        trainGrid.put((Object)"/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/mipacq/train:/projects/data/assertion/data/preprocessed_data/negex", (Object)SHARP_MIPACQ_NEGEX_FEDA);
        trainGrid.put((Object)"/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/i2b2/train:/projects/data/assertion/data/preprocessed_data/negex", (Object)SHARP_I2B2_NEGEX_FEDA);
        trainGrid.put((Object)"/projects/data/assertion/data/preprocessed_data/sharp/train:/projects/data/assertion/data/preprocessed_data/i2b2/train:/projects/data/assertion/data/preprocessed_data/mipacq/train:/projects/data/assertion/data/preprocessed_data/negex", (Object)SHARP_I2B2_MIPACQ_NEGEX_FEDA);
    }
}

