/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.mtom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.type.mtom.AbstractXOPType;
import org.apache.cxf.aegis.type.mtom.StreamDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Attachment;

public class DataHandlerType
extends AbstractXOPType {
    public DataHandlerType(boolean useXmimeContentType, String expectedContentTypes) {
        super(useXmimeContentType, expectedContentTypes);
    }

    @Override
    protected Object readAttachment(Attachment att, Context context) {
        return att.getDataHandler();
    }

    @Override
    protected Attachment createAttachment(Object object, String id) {
        DataHandler handler = (DataHandler)object;
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(true);
        return att;
    }

    @Override
    protected String getContentType(Object object, Context context) {
        return ((DataHandler)object).getContentType();
    }

    @Override
    protected Object wrapBytes(byte[] bareBytes, String contentType) {
        return new DataHandler((DataSource)new StreamDataSource(contentType, new ByteArrayInputStream(bareBytes)));
    }

    @Override
    protected byte[] getBytes(Object object) {
        DataHandler handler = (DataHandler)object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            InputStream stream = handler.getInputStream();
            IOUtils.copy((InputStream)stream, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }
}

