/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.cr.UriCollectionReader;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

@PipeBitInfo(name="Anafora XML Reader (DeepPhe)", description="Reads annotations from DeepPhe schema Anafora XML files in a directory.", role=PipeBitInfo.Role.SPECIAL, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class DeepPheAnaforaXMLReader
extends JCasAnnotator_ImplBase {
    private static Logger LOGGER = Logger.getLogger(DeepPheAnaforaXMLReader.class);
    public static final String PARAM_ANAFORA_DIRECTORY = "anaforaDirectory";
    @ConfigurationParameter(name="anaforaDirectory", description="root directory of the Anafora-annotated files, with one subdirectory for each annotated file")
    private File anaforaDirectory;
    public static final String PARAM_ANAFORA_XML_SUFFIXES = "anaforaSuffixes";
    @ConfigurationParameter(name="anaforaSuffixes", mandatory=false, description="list of suffixes that might be added to a file name to identify the Anafora XML annotations file; only the first suffix corresponding to a file will be used")
    private String[] anaforaXMLSuffixes = new String[]{".UmlsDeepPhe.dave.completed.xml"};

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(DeepPheAnaforaXMLReader.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getDescription(File anaforaDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(DeepPheAnaforaXMLReader.class, (Object[])new Object[]{PARAM_ANAFORA_DIRECTORY, anaforaDirectory});
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        File textFile = new File(ViewUriUtil.getURI((JCas)jCas));
        LOGGER.info((Object)("processing " + textFile));
        File corefFile = new File(textFile.getPath() + ".UmlsDeepPhe.dave.completed.xml");
        ArrayList possibleXMLFiles = Lists.newArrayList();
        for (String anaforaXMLSuffix : this.anaforaXMLSuffixes) {
            if (this.anaforaDirectory == null) {
                possibleXMLFiles.add(new File(textFile + anaforaXMLSuffix));
                continue;
            }
            possibleXMLFiles.add(new File(textFile.getPath() + anaforaXMLSuffix));
        }
        File xmlFile = null;
        for (File possibleXMLFile : possibleXMLFiles) {
            if (!possibleXMLFile.exists()) continue;
            xmlFile = possibleXMLFile;
            break;
        }
        if (this.anaforaXMLSuffixes.length > 0 && xmlFile == null) {
            throw new IllegalArgumentException("no Anafora XML file found from " + possibleXMLFiles);
        }
        if (xmlFile != null) {
            DeepPheAnaforaXMLReader.processXmlFile(jCas, xmlFile);
        }
        if (corefFile.exists()) {
            DeepPheAnaforaXMLReader.processXmlFile(jCas, corefFile);
        }
    }

    private static void processXmlFile(JCas jCas, File xmlFile) throws AnalysisEngineProcessException {
        Element dataElem;
        try {
            dataElem = new SAXBuilder().build(xmlFile.toURI().toURL()).getRootElement();
        }
        catch (MalformedURLException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        int curEventId = 1;
        int docLen = jCas.getDocumentText().length();
        for (Element annotationsElem : dataElem.getChildren("annotations")) {
            for (Element entityElem : annotationsElem.getChildren("entity")) {
                String id = DeepPheAnaforaXMLReader.removeSingleChildText(entityElem, "id", null);
                Element spanElem = DeepPheAnaforaXMLReader.removeSingleChild(entityElem, "span", id);
                String type = DeepPheAnaforaXMLReader.removeSingleChildText(entityElem, "type", id);
                String parType = DeepPheAnaforaXMLReader.removeSingleChildText(entityElem, "parentsType", id);
                Element propertiesElem = DeepPheAnaforaXMLReader.removeSingleChild(entityElem, "properties", id);
                int begin = Integer.MAX_VALUE;
                int end = Integer.MIN_VALUE;
                for (String spanString : spanElem.getText().split(";")) {
                    String[] beginEndStrings = spanString.split(",");
                    if (beginEndStrings.length != 2) {
                        DeepPheAnaforaXMLReader.error("span not of the format 'number,number'", id);
                    }
                    int spanBegin = Integer.parseInt(beginEndStrings[0]);
                    int spanEnd = Integer.parseInt(beginEndStrings[1]);
                    if (spanBegin < begin) {
                        begin = spanBegin;
                    }
                    if (spanEnd <= end) continue;
                    end = spanEnd;
                }
                if (begin < 0 || end >= docLen) {
                    DeepPheAnaforaXMLReader.error("Illegal begin or end boundary", id);
                    continue;
                }
                if (!type.equals("Anatomical_site") && parType.equals("UMLSEntities") || parType.equals("Metastasis_Entities")) {
                    String docTimeRel = DeepPheAnaforaXMLReader.removeSingleChildText(propertiesElem, "DocTimeRel", id);
                    if (docTimeRel == null) {
                        DeepPheAnaforaXMLReader.error("no docTimeRel, assuming OVERLAP", id);
                        continue;
                    }
                    EventMention eventMention = new EventMention(jCas, begin, end);
                    Event event = new Event(jCas);
                    EventProperties eventProperties = new EventProperties(jCas);
                    eventProperties.setDocTimeRel(docTimeRel);
                    eventProperties.setCategory(type);
                    eventProperties.addToIndexes();
                    event.setConfidence(1.0);
                    event.setDiscoveryTechnique(2);
                    event.setProperties(eventProperties);
                    event.setMentions(new FSArray(jCas, 1));
                    event.setMentions(0, (IdentifiedAnnotation)eventMention);
                    event.addToIndexes();
                    eventMention.setId(curEventId++);
                    eventMention.setConfidence(1.0f);
                    eventMention.setDiscoveryTechnique(2);
                    eventMention.setEvent(event);
                    eventMention.addToIndexes();
                }
                DeepPheAnaforaXMLReader.removeSingleChild(entityElem, "parentsType", id);
                if (propertiesElem.getChildren().isEmpty() && entityElem.getChildren().isEmpty()) continue;
                ArrayList children = Lists.newArrayList();
                for (Element child : propertiesElem.getChildren()) {
                    children.add(child.getName());
                }
                for (Element child : entityElem.getChildren()) {
                    children.add(child.getName());
                }
                DeepPheAnaforaXMLReader.error("unprocessed children " + children, id);
            }
        }
    }

    private static Element getSingleChild(Element elem, String elemName, String causeID) {
        List children = elem.getChildren(elemName);
        if (children.size() != 1) {
            DeepPheAnaforaXMLReader.error(String.format("not exactly one '%s' child", elemName), causeID);
        }
        return children.size() > 0 ? (Element)children.get(0) : null;
    }

    private static Element removeSingleChild(Element elem, String elemName, String causeID) {
        Element child = DeepPheAnaforaXMLReader.getSingleChild(elem, elemName, causeID);
        elem.removeChildren(elemName);
        return child;
    }

    private static String removeSingleChildText(Element elem, String elemName, String causeID) {
        Element child = DeepPheAnaforaXMLReader.getSingleChild(elem, elemName, causeID);
        String text = null;
        if (child != null) {
            text = child.getText();
        }
        if (text == null || text.isEmpty()) {
            DeepPheAnaforaXMLReader.error(String.format("an empty '%s' child", elemName), causeID);
            text = null;
        }
        elem.removeChildren(elemName);
        return text;
    }

    private static void error(String found, String id) {
        LOGGER.error((Object)String.format("found %s in annotation with ID %s", found, id));
    }

    public static void main(String[] args) throws Exception {
        ArrayList files = Lists.newArrayList();
        for (String path : args) {
            files.add(new File(path));
        }
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles((Collection)files);
        AnalysisEngine engine = AnalysisEngineFactory.createEngine(DeepPheAnaforaXMLReader.class, (Object[])new Object[0]);
        SimplePipeline.runPipeline((CollectionReader)reader, (AnalysisEngine[])new AnalysisEngine[]{engine});
    }
}

