/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class IdentifiedAnnotationFeatureExtractor
implements FeatureExtractor1 {
    private String name;
    private Map<String, double[]> textDoublesMap;
    private double[] meanValues;

    public static Map<String, double[]> parseTextDoublesMap(File file, Charset charset) throws IOException {
        return (Map)Files.readLines((File)file, (Charset)charset, (LineProcessor)new StringToDoublesProcessor());
    }

    public IdentifiedAnnotationFeatureExtractor(String name, Map<String, double[]> textDoublesMap) {
        this.name = name;
        this.textDoublesMap = textDoublesMap;
        int nMapEntries = this.textDoublesMap.size();
        if (nMapEntries == 0) {
            throw new IllegalArgumentException("textDoublesMap cannot be empty");
        }
        int nValues = textDoublesMap.entrySet().iterator().next().getValue().length;
        this.meanValues = new double[nValues];
        for (double[] values : textDoublesMap.values()) {
            for (int i = 0; i < values.length; ++i) {
                int n = i;
                this.meanValues[n] = this.meanValues[n] + values[i];
            }
        }
        int i = 0;
        while (i < this.meanValues.length) {
            int n = i++;
            this.meanValues[n] = this.meanValues[n] / (double)nMapEntries;
        }
    }

    public List<Feature> extract(JCas view, Annotation annotation) throws CleartkExtractorException {
        Map coveringMap = JCasUtil.indexCovering((JCas)view, BaseToken.class, IdentifiedAnnotation.class);
        BaseToken targetTokenAnnotation = (BaseToken)annotation;
        Collection idannoList = (Collection)coveringMap.get(targetTokenAnnotation);
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (idannoList != null && !idannoList.isEmpty()) {
            features.add(new Feature("TokenInside", (Object)"A_IdentifiedAnnotation"));
            for (IdentifiedAnnotation ida : idannoList) {
                double[] values = this.textDoublesMap.get(ida.getCoveredText().toLowerCase());
                if (values == null) continue;
                features.add(new Feature(this.name, (Object)"is_A_KnownEvent"));
                break;
            }
        }
        return features;
    }

    static class StringToDoublesProcessor
    implements LineProcessor<Map<String, double[]>> {
        private Logger logger = Logger.getLogger(this.getClass().getName());
        private Map<String, double[]> result = new HashMap<String, double[]>();
        private int length = -1;

        StringToDoublesProcessor() {
        }

        public Map<String, double[]> getResult() {
            return this.result;
        }

        public boolean processLine(String line) throws IOException {
            String[] parts = line.trim().split(",");
            String key = parts[0];
            int partsOffset = 0;
            if (this.length == -1) {
                this.length = parts.length;
            } else if (parts.length != this.length) {
                String message = "expected %d parts, found %d, skipping line '%s'";
                this.logger.warning(String.format(message, this.length, parts.length, line));
                return true;
            }
            double[] values = new double[parts.length - 1];
            for (int i = 0; i < values.length; ++i) {
                values[i] = Double.parseDouble(parts[i + 1 + partsOffset]);
            }
            this.result.put(key, values);
            return true;
        }
    }
}

