/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.ctakes.constituency.parser.util.TreeUtils;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;

public class TimexTreeAlignmentStatistics {
    public static void main(String[] args) throws UIMAException, IOException {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles(THYMEData.getFilesFor(trainItems, options.getRawTextDirectory()));
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(UriToDocumentTextAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(Evaluation_ImplBase.XMIReader.class, (Object[])new Object[]{"XMIDirectory", options.getXMIDirectory()}), new String[0]);
        AnalysisEngine ae = aggregateBuilder.createAggregate();
        int numMentions = 0;
        int numMatches = 0;
        JCasIterator casIter = new JCasIterator(reader, new AnalysisEngine[]{ae});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            for (Segment segment : JCasUtil.select((JCas)jCas, Segment.class)) {
                if (THYMEData.SEGMENTS_TO_SKIP.contains(segment.getId())) continue;
                List mentions = JCasUtil.selectCovered((JCas)jCas.getView("GoldView"), TimeMention.class, (AnnotationFS)segment);
                for (TimeMention mention : mentions) {
                    ++numMentions;
                    boolean match = false;
                    List nodes = JCasUtil.selectCovered((JCas)jCas, TreebankNode.class, (AnnotationFS)mention);
                    for (TreebankNode node : nodes) {
                        if (node.getBegin() != mention.getBegin() || node.getEnd() != mention.getEnd()) continue;
                        ++numMatches;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    List coveringNodes = JCasUtil.selectCovering((JCas)jCas, TreebankNode.class, (int)mention.getBegin(), (int)mention.getEnd());
                    TreebankNode smallestCoveringNode = null;
                    int smallestLen = Integer.MAX_VALUE;
                    for (TreebankNode node : coveringNodes) {
                        int len = node.getEnd() - node.getBegin();
                        if (len >= smallestLen) continue;
                        smallestLen = len;
                        smallestCoveringNode = node;
                    }
                    System.out.println("No alignment for: " + mention.getCoveredText());
                    System.out.println("  Smallest covering treebank node is: " + (smallestCoveringNode == null ? "null" : smallestCoveringNode.getCoveredText()));
                    System.out.println("  " + (smallestCoveringNode == null ? "no tree" : TreeUtils.tree2str((TreebankNode)smallestCoveringNode)));
                }
            }
        }
        System.out.printf("Found %d mentions, %d match with node spans\n", numMentions, numMatches);
    }

    static interface Options {
        @Option(longName={"xmi"})
        public File getXMIDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"text"})
        public File getRawTextDirectory();
    }
}

