/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.duration;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.relationextractor.eval.XMIReader;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class EventDurationDistribution {
    private static Class<? extends EventMention> targetClass = MedicationMention.class;

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        List<File> trainFiles = Arrays.asList(options.inputDirectory.listFiles());
        CollectionReader collectionReader = EventDurationDistribution.getCollectionReader(trainFiles);
        AnalysisEngine temporalDurationExtractor = AnalysisEngineFactory.createEngine(TemporalDurationExtractor.class, (Object[])new Object[]{"OutputFile", options.outputFile});
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{temporalDurationExtractor});
    }

    private static CollectionReader getCollectionReader(List<File> items) throws Exception {
        String[] paths = new String[items.size()];
        Collections.sort(items, new FileSizeComparator());
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = items.get(i).getPath();
        }
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static class FileSizeComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            if (o1.length() > o2.length()) {
                return 1;
            }
            if (o1.length() < o2.length()) {
                return -1;
            }
            return 0;
        }
    }

    public static class TemporalDurationExtractor
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="OutputFile", mandatory=true, description="path to the output file that will store the distributions")
        private String outputFilePath;
        private File outputFile;
        private static final String regex = "(sec|min|hour|hrs|day|week|wk|month|year|yr|decade)";
        private static final Map<String, String> abbreviationToTimeUnit = ImmutableMap.builder().put((Object)"sec", (Object)"second").put((Object)"min", (Object)"minute").put((Object)"hour", (Object)"hour").put((Object)"hrs", (Object)"hour").put((Object)"day", (Object)"day").put((Object)"week", (Object)"week").put((Object)"wk", (Object)"week").put((Object)"month", (Object)"month").put((Object)"year", (Object)"year").put((Object)"yr", (Object)"year").put((Object)"decade", (Object)"decade").build();
        private static final int MAXDISTANCE = 2;
        Pattern pattern = Pattern.compile("(sec|min|hour|hrs|day|week|wk|month|year|yr|decade)", 2);

        public void initialize(UimaContext context) throws ResourceInitializationException {
            super.initialize(context);
            this.outputFile = new File(this.outputFilePath);
            if (this.outputFile.exists()) {
                System.out.println(this.outputFile + " exists... deleting...");
                this.outputFile.delete();
            }
        }

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            Collection ids = JCasUtil.select((JCas)jCas, DocumentID.class);
            String fileName = ((DocumentID)ids.iterator().next()).getDocumentID();
            String mentionText = fileName.split("\\.")[0];
            HashMultiset durationDistribution = HashMultiset.create();
            for (EventMention mention : JCasUtil.select((JCas)jCas, (Class)targetClass)) {
                TimeMention nearestTimeMention;
                if (!mention.getCoveredText().equals(mentionText) || TemporalDurationExtractor.isNegated(jCas, mention) || TemporalDurationExtractor.isMedicationPattern(jCas, mention) || (nearestTimeMention = TemporalDurationExtractor.getNearestTimeMention(jCas, mention)) == null) continue;
                HashSet<String> timeUnits = Utils.getTimeUnits(nearestTimeMention.getCoveredText());
                if (timeUnits.size() > 0) {
                    for (String timeUnit : timeUnits) {
                        durationDistribution.add((Object)timeUnit);
                    }
                    continue;
                }
                Matcher matcher = this.pattern.matcher(nearestTimeMention.getCoveredText());
                while (matcher.find()) {
                    String matchedTimeUnit = matcher.group();
                    String normalizedTimeUnit = abbreviationToTimeUnit.get(matchedTimeUnit);
                    durationDistribution.add((Object)normalizedTimeUnit);
                }
            }
            if (durationDistribution.size() > 0) {
                try {
                    Files.append((CharSequence)(Utils.formatDistribution(mentionText, (Multiset<String>)durationDistribution, ", ", false) + "\n"), (File)this.outputFile, (Charset)Charsets.UTF_8);
                }
                catch (IOException e) {
                    System.out.println("Could not open output file: " + this.outputFile);
                }
            } else {
                System.out.println("No duration data for: " + mentionText);
            }
        }

        private static boolean isNegated(JCas jCas, EventMention mention) {
            for (BaseToken token : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)mention, (int)3)) {
                if (!token.getCoveredText().equals("no") && !token.getCoveredText().equals("not") && !token.getCoveredText().equals("off")) continue;
                return true;
            }
            return false;
        }

        private static boolean isMedicationPattern(JCas jCas, EventMention mention) {
            for (BaseToken token : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)mention, (int)1)) {
                if (!token.getCoveredText().equals("for")) continue;
                return true;
            }
            return false;
        }

        private static TimeMention getNearestTimeMention(JCas jCas, EventMention mention) {
            List timeMentions = JCasUtil.selectFollowing((JCas)jCas, TimeMention.class, (AnnotationFS)mention, (int)1);
            if (timeMentions.size() < 1) {
                return null;
            }
            assert (timeMentions.size() == 1);
            TimeMention nearestTimeMention = (TimeMention)timeMentions.get(0);
            int distance = JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)mention, (AnnotationFS)nearestTimeMention).size();
            if (distance > 2) {
                return null;
            }
            return nearestTimeMention;
        }

        private static String getAnnotationContext(Annotation annotation, int maxContextWindowSize) {
            String text = annotation.getCAS().getDocumentText();
            int begin = Math.max(0, annotation.getBegin() - maxContextWindowSize);
            int end = Math.min(text.length(), annotation.getEnd() + maxContextWindowSize);
            return text.substring(begin, end).replaceAll("[\r\n]", " ");
        }

        private static String formatDistribution(Multiset<String> durationDistribution) {
            List<String> durationBins = Arrays.asList("second", "minute", "hour", "day", "week", "month", "year", "decade");
            LinkedList<Integer> durationValues = new LinkedList<Integer>();
            for (String durationBin : durationBins) {
                durationValues.add(durationDistribution.count((Object)durationBin));
            }
            Joiner joiner = Joiner.on((char)',');
            return joiner.join(durationValues);
        }
    }

    public static class Options {
        @Option(name="--input-dir", usage="specify the path to the directory containing the xmi files", required=true)
        public File inputDirectory;
        @Option(name="--output-file", usage="specify the path to the output file", required=true)
        public String outputFile;
    }
}

