/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResponseMessage;

public class SessionXAResponseMessage_V2
extends SessionXAResponseMessage {
    private long correlationID;

    public SessionXAResponseMessage_V2(long correlationID, boolean isError, int responseCode, String message) {
        super(isError, responseCode, message);
        this.correlationID = correlationID;
    }

    public SessionXAResponseMessage_V2() {
    }

    @Override
    public long getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeLong(this.correlationID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.correlationID = buffer.readableBytes() >= 8 ? buffer.readLong() : -1L;
    }

    @Override
    public final boolean isResponse() {
        return true;
    }

    @Override
    public final boolean isResponseAsync() {
        return true;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", error=" + this.error);
        sb.append(", message=" + this.message);
        sb.append(", responseCode=" + this.responseCode);
        sb.append(", correlationID=" + this.correlationID);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.correlationID);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAResponseMessage_V2)) {
            return false;
        }
        SessionXAResponseMessage_V2 other = (SessionXAResponseMessage_V2)obj;
        return this.correlationID == other.correlationID;
    }
}

