/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import jdk.incubator.foreign.MemoryAccess;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.CompareAndCopy;
import org.apache.datasketches.memory.internal.NativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.NativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.NonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.internal.WritableBufferImpl;
import org.apache.datasketches.memory.internal.WritableMemoryImpl;
import org.apache.datasketches.memory.internal.XxHash64;

abstract class ResourceImpl
implements Resource {
    static final String JDK;
    static final int JDK_MAJOR;
    static final int BOOLEAN_SHIFT = 0;
    static final int BYTE_SHIFT = 0;
    static final long SHORT_SHIFT = 1L;
    static final long CHAR_SHIFT = 1L;
    static final long INT_SHIFT = 2L;
    static final long LONG_SHIFT = 3L;
    static final long FLOAT_SHIFT = 2L;
    static final long DOUBLE_SHIFT = 3L;
    static final int WRITABLE = 0;
    static final int READONLY = 1;
    static final int REGION = 2;
    static final int DUPLICATE = 4;
    static final int HEAP = 0;
    static final int DIRECT = 8;
    static final int MAP = 16;
    static final int NATIVE_BO = 0;
    static final int NONNATIVE_BO = 32;
    static final int MEMORY = 0;
    static final int BUFFER = 64;
    static final int BYTEBUF = 128;
    static final String LS;
    static final ByteOrder NATIVE_BYTE_ORDER;
    static final ByteOrder NON_NATIVE_BYTE_ORDER;
    final MemorySegment seg;
    final int typeId;
    MemoryRequestServer memReqSvr = null;

    ResourceImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr) {
        this.seg = seg;
        this.typeId = typeId;
        this.memReqSvr = memReqSvr;
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        int mask = 17;
        boolean test = false;
        return (this.typeId & 0x11) != 0 ? null : this.memReqSvr;
    }

    @Override
    public boolean hasMemoryRequestServer() {
        return this.memReqSvr != null;
    }

    @Override
    public void setMemoryRequestServer(MemoryRequestServer memReqSvr) {
        this.memReqSvr = memReqSvr;
    }

    static void checkBounds(long reqOff, long reqLen, long allocSize) {
        if ((reqOff | reqLen | reqOff + reqLen | allocSize - (reqOff + reqLen)) < 0L) {
            throw new IllegalArgumentException("reqOffset: " + reqOff + ", reqLength: " + reqLen + ", (reqOff + reqLen): " + (reqOff + reqLen) + ", allocSize: " + allocSize);
        }
    }

    static void checkJavaVersion(String jdkVer, int p0) {
        if (p0 != 17) {
            throw new IllegalArgumentException("Unsupported JDK Major Version, must be 17; " + jdkVer);
        }
    }

    private static String pad(String s, int fieldLen) {
        return Util.characterPad(s, fieldLen, ' ', true);
    }

    static int[] parseJavaVersion(String jdkVer) {
        int p1;
        int p0;
        try {
            String[] parts = jdkVer.trim().split("\\.");
            parts = parts[0].split("\\.");
            p0 = Integer.parseInt(parts[0]);
            p1 = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException("Improper Java -version string: " + jdkVer + LS + e);
        }
        ResourceImpl.checkJavaVersion(jdkVer, p0);
        return new int[]{p0, p1};
    }

    static final String typeDecode(int typeId) {
        StringBuilder sb = new StringBuilder();
        int group1 = typeId & 7;
        switch (group1) {
            case 0: {
                sb.append(ResourceImpl.pad("Writable + ", 32));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("ReadOnly + ", 32));
                break;
            }
            case 2: {
                sb.append(ResourceImpl.pad("Writable + Region + ", 32));
                break;
            }
            case 3: {
                sb.append(ResourceImpl.pad("ReadOnly + Region + ", 32));
                break;
            }
            case 4: {
                sb.append(ResourceImpl.pad("Writable + Duplicate + ", 32));
                break;
            }
            case 5: {
                sb.append(ResourceImpl.pad("ReadOnly + Duplicate + ", 32));
                break;
            }
            case 6: {
                sb.append(ResourceImpl.pad("Writable + Region + Duplicate + ", 32));
                break;
            }
            case 7: {
                sb.append(ResourceImpl.pad("ReadOnly + Region + Duplicate + ", 32));
                break;
            }
        }
        int group2 = typeId >>> 3 & 3;
        switch (group2) {
            case 0: {
                sb.append(ResourceImpl.pad("Heap + ", 15));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("Direct + ", 15));
                break;
            }
            case 2: {
                sb.append(ResourceImpl.pad("Map + Direct + ", 15));
                break;
            }
            case 3: {
                sb.append(ResourceImpl.pad("Map + Direct + ", 15));
                break;
            }
        }
        int group3 = typeId >>> 5 & 1;
        switch (group3) {
            case 0: {
                sb.append(ResourceImpl.pad("NativeOrder + ", 17));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("NonNativeOrder + ", 17));
                break;
            }
        }
        int group4 = typeId >>> 6 & 1;
        switch (group4) {
            case 0: {
                sb.append(ResourceImpl.pad("Memory + ", 9));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("Buffer + ", 9));
                break;
            }
        }
        int group5 = typeId >>> 7 & 1;
        switch (group5) {
            case 0: {
                sb.append(ResourceImpl.pad("", 10));
                break;
            }
            case 1: {
                sb.append(ResourceImpl.pad("ByteBuffer", 10));
                break;
            }
        }
        return sb.toString();
    }

    static final WritableBuffer selectBuffer(MemorySegment segment, int type, MemoryRequestServer memReqSvr, boolean byteBufferType, boolean mapType, boolean nativeBOType) {
        MemoryRequestServer memReqSvr2 = byteBufferType || mapType ? null : memReqSvr;
        WritableBufferImpl wbuf = nativeBOType ? new NativeWritableBufferImpl(segment, type, memReqSvr2) : new NonNativeWritableBufferImpl(segment, type, memReqSvr2);
        return wbuf;
    }

    static final WritableMemory selectMemory(MemorySegment segment, int type, MemoryRequestServer memReqSvr, boolean byteBufferType, boolean mapType, boolean nativeBOType) {
        MemoryRequestServer memReqSvr2 = byteBufferType || mapType ? null : memReqSvr;
        WritableMemoryImpl wmem = nativeBOType ? new NativeWritableMemoryImpl(segment, type, memReqSvr2) : new NonNativeWritableMemoryImpl(segment, type, memReqSvr2);
        return wmem;
    }

    static final String toHex(ResourceImpl resourceImpl, String comment, long offsetBytes, int lengthBytes, boolean withData) {
        MemorySegment seg = resourceImpl.seg;
        long capacity = seg.byteSize();
        ResourceImpl.checkBounds(offsetBytes, lengthBytes, capacity);
        StringBuilder sb = new StringBuilder();
        String theComment = comment != null ? comment : "";
        String addHCStr = Integer.toHexString(seg.address().hashCode());
        MemoryRequestServer memReqSvr = resourceImpl.getMemoryRequestServer();
        String memReqStr = memReqSvr != null ? memReqSvr.getClass().getSimpleName() + ", " + Integer.toHexString(memReqSvr.hashCode()) : "null";
        sb.append(LS + "### DataSketches Memory Component SUMMARY ###").append(LS);
        sb.append("Optional Comment       : ").append(theComment).append(LS);
        sb.append("TypeId String          : ").append(ResourceImpl.typeDecode(resourceImpl.typeId)).append(LS);
        sb.append("OffsetBytes            : ").append(offsetBytes).append(LS);
        sb.append("LengthBytes            : ").append(lengthBytes).append(LS);
        sb.append("Capacity               : ").append(capacity).append(LS);
        sb.append("MemoryAddress hashCode : ").append(addHCStr).append(LS);
        sb.append("MemReqSvr, hashCode    : ").append(memReqStr).append(LS);
        sb.append("Read Only              : ").append(resourceImpl.isReadOnly()).append(LS);
        sb.append("Type Byte Order        : ").append(resourceImpl.getTypeByteOrder().toString()).append(LS);
        sb.append("Native Byte Order      : ").append(ByteOrder.nativeOrder().toString()).append(LS);
        sb.append("JDK Runtime Version    : ").append(JDK).append(LS);
        if (withData) {
            sb.append("Data, LittleEndian     :  0  1  2  3  4  5  6  7");
            for (long i = 0L; i < (long)lengthBytes; ++i) {
                int b = MemoryAccess.getByteAtOffset((MemorySegment)seg, (long)(offsetBytes + i)) & 0xFF;
                if (i % 8L == 0L) {
                    sb.append(String.format("%n%23s: ", offsetBytes + i));
                }
                sb.append(String.format("%02x ", b));
            }
        }
        sb.append(LS + "### END SUMMARY ###");
        sb.append(LS);
        return sb.toString();
    }

    @Override
    public final ByteBuffer asByteBufferView(ByteOrder order) {
        ByteBuffer byteBuffer = this.seg.asByteBuffer().order(order);
        return byteBuffer;
    }

    @Override
    public void close() {
        this.seg.scope().close();
    }

    @Override
    public final boolean equalTo(long thisOffsetBytes, Resource that, long thatOffsetBytes, long lengthBytes) {
        if (that == null) {
            return false;
        }
        return CompareAndCopy.equals(this.seg, thisOffsetBytes, ((ResourceImpl)that).seg, thatOffsetBytes, lengthBytes);
    }

    @Override
    public void force() {
        this.seg.force();
    }

    @Override
    public final long getCapacity() {
        return this.seg.byteSize();
    }

    @Override
    public Thread getOwnerThread() {
        return this.seg.scope().ownerThread();
    }

    @Override
    public final long getRelativeOffset(Resource that) {
        ResourceImpl that2 = (ResourceImpl)that;
        return this.seg.address().segmentOffset(that2.seg);
    }

    @Override
    public final ByteOrder getTypeByteOrder() {
        return (this.typeId & 0x20) > 0 ? NON_NATIVE_BYTE_ORDER : NATIVE_BYTE_ORDER;
    }

    @Override
    public final boolean hasByteBuffer() {
        return (this.typeId & 0x80) > 0;
    }

    @Override
    public boolean isAlive() {
        return this.seg.scope().isAlive();
    }

    @Override
    public final boolean isByteOrderCompatible(ByteOrder byteOrder) {
        ByteOrder typeBO = this.getTypeByteOrder();
        return typeBO == ByteOrder.nativeOrder() && typeBO == byteOrder;
    }

    @Override
    public final boolean isBuffer() {
        return (this.typeId & 0x40) > 0;
    }

    @Override
    public boolean isCloseable() {
        return (this.seg.isNative() || this.seg.isMapped()) && this.seg.scope().isAlive() && !this.seg.scope().isImplicit();
    }

    @Override
    public final boolean isDirect() {
        assert (this.seg.isNative() == (this.typeId & 8) > 0);
        return this.seg.isNative();
    }

    @Override
    public final boolean isDuplicate() {
        return (this.typeId & 4) > 0;
    }

    @Override
    public final boolean isHeap() {
        return !this.isDirect() && !this.isMapped();
    }

    @Override
    public boolean isLoaded() {
        return this.seg.isLoaded();
    }

    @Override
    public boolean isMapped() {
        assert (this.seg.isMapped() == (this.typeId & 0x10) > 0);
        return this.seg.isMapped();
    }

    @Override
    public final boolean isMemory() {
        return (this.typeId & 0x40) == 0;
    }

    @Override
    public final boolean isReadOnly() {
        assert (this.seg.isReadOnly() == (this.typeId & 1) > 0);
        return this.seg.isReadOnly();
    }

    @Override
    public final boolean isRegion() {
        return (this.typeId & 2) > 0;
    }

    @Override
    public final boolean isSameResource(Resource that) {
        ResourceImpl that2 = (ResourceImpl)that;
        return this.seg.address().equals((Object)that2.seg.address());
    }

    @Override
    public void load() {
        this.seg.load();
    }

    @Override
    public long mismatch(Resource that) {
        Objects.requireNonNull(that);
        if (!that.isAlive()) {
            throw new IllegalArgumentException("Given argument is not alive.");
        }
        ResourceImpl thatBSI = (ResourceImpl)that;
        return this.seg.mismatch(thatBSI.seg);
    }

    @Override
    public final long nativeOverlap(Resource that) {
        if (that == null) {
            return 0L;
        }
        if (!that.isAlive()) {
            return 0L;
        }
        ResourceImpl thatBSI = (ResourceImpl)that;
        if (this == thatBSI) {
            return this.seg.byteSize();
        }
        return ResourceImpl.nativeOverlap(this.seg, thatBSI.seg);
    }

    static final long nativeOverlap(MemorySegment segA, MemorySegment segB) {
        if (!segA.isNative() || !segB.isNative()) {
            return 0L;
        }
        long bytesA = segA.byteSize();
        long bytesB = segB.byteSize();
        long lA = segA.address().toRawLongValue();
        long lB = segB.address().toRawLongValue();
        long rA = lA + bytesA;
        long rB = lB + bytesB;
        if (rA <= lB || rB <= lA) {
            return 0L;
        }
        long result = bytesA == bytesB ? ResourceImpl.nativeOverlapEqualSizes(lA, rA, lB, rB) : ResourceImpl.nativeOverlapNotEqualSizes(lA, rA, lB, rB);
        return lB < lA ? -result : result;
    }

    private static final long nativeOverlapEqualSizes(long lA, long rA, long lB, long rB) {
        if (lA == lB) {
            return rA - lA;
        }
        return lA < lB ? rA - lB : rB - lA;
    }

    private static final long nativeOverlapNotEqualSizes(long lA, long rA, long lB, long rB) {
        return rB - lB < rA - lA ? ResourceImpl.biggerSmaller(lA, rA, lB, rB) : ResourceImpl.biggerSmaller(lB, rB, lA, rA);
    }

    private static final long biggerSmaller(long lLarge, long rLarge, long lSmall, long rSmall) {
        if (rSmall <= rLarge && lLarge <= lSmall) {
            return rSmall - lSmall;
        }
        return rLarge < rSmall ? rLarge - lSmall : rSmall - lLarge;
    }

    @Override
    public ResourceScope scope() {
        return this.seg.scope();
    }

    @Override
    public ByteBuffer toByteBuffer(ByteOrder order) {
        Objects.requireNonNull(order, "The input ByteOrder must not be null");
        return ByteBuffer.wrap(this.seg.toByteArray());
    }

    @Override
    public String toString() {
        return this.toString("", 0L, (int)this.getCapacity(), false);
    }

    @Override
    public final String toString(String comment, long offsetBytes, int lengthBytes, boolean withData) {
        return ResourceImpl.toHex(this, comment, offsetBytes, lengthBytes, withData);
    }

    @Override
    public MemorySegment toMemorySegment() {
        MemorySegment arrSeg = MemorySegment.ofArray((byte[])new byte[(int)this.seg.byteSize()]);
        arrSeg.copyFrom(this.seg);
        return arrSeg;
    }

    @Override
    public void unload() {
        this.seg.unload();
    }

    @Override
    public final long xxHash64(long in, long seed) {
        return XxHash64.hash(in, seed);
    }

    @Override
    public final long xxHash64(long offsetBytes, long lengthBytes, long seed) {
        return XxHash64.hash(this.seg, offsetBytes, lengthBytes, seed);
    }

    static {
        LS = System.getProperty("line.separator");
        NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
        NON_NATIVE_BYTE_ORDER = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        String jdkVer = System.getProperty("java.version");
        int[] p = ResourceImpl.parseJavaVersion(jdkVer);
        JDK = p[0] + "." + p[1];
        JDK_MAJOR = p[0] == 1 ? p[1] : p[0];
    }
}

