/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.frequencies;

import java.util.Iterator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.pig.frequencies.FrequentStringsSketchToEstimates;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FrequentStringsSketchToEstimatesTest {
    @Test
    public void nullInput() throws Exception {
        FrequentStringsSketchToEstimates func = new FrequentStringsSketchToEstimates();
        DataBag bag = (DataBag)func.exec(null);
        Assert.assertNull((Object)bag);
    }

    @Test
    public void emptyInput() throws Exception {
        FrequentStringsSketchToEstimates func = new FrequentStringsSketchToEstimates();
        DataBag bag = (DataBag)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)bag);
    }

    @Test
    public void emptySketch() throws Exception {
        FrequentStringsSketchToEstimates func = new FrequentStringsSketchToEstimates();
        ItemsSketch sketch = new ItemsSketch(8);
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe())));
        DataBag bag = (DataBag)func.exec(inputTuple);
        Assert.assertNotNull((Object)bag);
        Assert.assertEquals((long)bag.size(), (long)0L);
    }

    @Test
    public void exact() throws Exception {
        FrequentStringsSketchToEstimates func = new FrequentStringsSketchToEstimates();
        ItemsSketch sketch = new ItemsSketch(8);
        sketch.update((Object)"a");
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe())));
        DataBag bag = (DataBag)func.exec(inputTuple);
        Assert.assertNotNull((Object)bag);
        Assert.assertEquals((long)bag.size(), (long)2L);
        Iterator it = bag.iterator();
        Tuple tuple1 = (Tuple)it.next();
        Assert.assertEquals((int)tuple1.size(), (int)4);
        Assert.assertEquals((String)((String)tuple1.get(0)), (String)"a");
        Assert.assertEquals((long)((Long)tuple1.get(1)), (long)2L);
        Assert.assertEquals((long)((Long)tuple1.get(2)), (long)2L);
        Assert.assertEquals((long)((Long)tuple1.get(3)), (long)2L);
        Tuple tuple2 = (Tuple)it.next();
        Assert.assertEquals((int)tuple2.size(), (int)4);
        Assert.assertEquals((String)((String)tuple2.get(0)), (String)"b");
        Assert.assertEquals((long)((Long)tuple2.get(1)), (long)1L);
        Assert.assertEquals((long)((Long)tuple2.get(2)), (long)1L);
        Assert.assertEquals((long)((Long)tuple2.get(3)), (long)1L);
    }

    @Test
    public void estimation() throws Exception {
        ItemsSketch sketch = new ItemsSketch(8);
        sketch.update((Object)"1", 1000L);
        sketch.update((Object)"2", 500L);
        sketch.update((Object)"3", 200L);
        sketch.update((Object)"4", 100L);
        sketch.update((Object)"5", 50L);
        sketch.update((Object)"6", 20L);
        sketch.update((Object)"7", 10L);
        sketch.update((Object)"8", 5L);
        sketch.update((Object)"9", 2L);
        sketch.update((Object)"10");
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe())));
        FrequentStringsSketchToEstimates func1 = new FrequentStringsSketchToEstimates("NO_FALSE_POSITIVES");
        DataBag bag1 = (DataBag)func1.exec(inputTuple);
        Assert.assertNotNull((Object)bag1);
        Assert.assertTrue((bag1.size() < 10L ? 1 : 0) != 0);
        FrequentStringsSketchToEstimates func2 = new FrequentStringsSketchToEstimates("NO_FALSE_NEGATIVES");
        DataBag bag2 = (DataBag)func2.exec(inputTuple);
        Assert.assertNotNull((Object)bag2);
        Assert.assertTrue((bag2.size() < 10L ? 1 : 0) != 0);
        Assert.assertTrue((bag1.size() < bag2.size() ? 1 : 0) != 0);
    }

    @Test
    public void schema() throws Exception {
        FrequentStringsSketchToEstimates func = new FrequentStringsSketchToEstimates();
        Schema schema = func.outputSchema(null);
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((int)schema.size(), (int)1);
        Assert.assertEquals((byte)schema.getField((int)0).type, (byte)120);
        Assert.assertEquals((int)schema.getField((int)0).schema.size(), (int)1);
        Assert.assertEquals((byte)schema.getField((int)0).schema.getField((int)0).type, (byte)110);
        Assert.assertEquals((int)schema.getField((int)0).schema.getField((int)0).schema.size(), (int)4);
        Assert.assertEquals((byte)schema.getField((int)0).schema.getField((int)0).schema.getField((int)0).type, (byte)55);
        Assert.assertEquals((byte)schema.getField((int)0).schema.getField((int)0).schema.getField((int)1).type, (byte)15);
        Assert.assertEquals((byte)schema.getField((int)0).schema.getField((int)0).schema.getField((int)2).type, (byte)15);
        Assert.assertEquals((byte)schema.getField((int)0).schema.getField((int)0).schema.getField((int)3).type, (byte)15);
    }
}

