/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.util.Arrays;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.pig.kll.GetQuantile;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantileTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void emptySketch() throws Exception {
        GetQuantile func = new GetQuantile();
        KllFloatsSketch sketch = new KllFloatsSketch();
        Float result = (Float)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.0)));
        Assert.assertEquals((float)result.floatValue(), (float)Float.NaN);
    }

    @Test
    public void normalCase() throws Exception {
        GetQuantile func = new GetQuantile();
        KllFloatsSketch sketch = new KllFloatsSketch();
        sketch.update(1.0f);
        Float result = (Float)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.5)));
        Assert.assertEquals((float)result.floatValue(), (float)1.0f);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongNumberOfInputs() throws Exception {
        GetQuantile func = new GetQuantile();
        func.exec(TUPLE_FACTORY.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetQuantile func = new GetQuantile();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForFraction() throws Exception {
        GetQuantile func = new GetQuantile();
        KllFloatsSketch sketch = new KllFloatsSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 1)));
    }
}

