/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.datasketches.quantiles.DoublesUnionBuilder;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class DataToDoublesSketch
extends EvalFunc<Tuple>
implements Accumulator<Tuple>,
Algebraic {
    private static final TupleFactory tupleFactory_ = TupleFactory.getInstance();
    private final DoublesUnionBuilder unionBuilder_ = DoublesUnion.builder();
    private DoublesUnion accumUnion_;

    public DataToDoublesSketch() {
        this(0);
    }

    public DataToDoublesSketch(String kStr) {
        this(Integer.parseInt(kStr));
    }

    public DataToDoublesSketch(int k) {
        if (k > 0) {
            this.unionBuilder_.setMaxK(k);
        }
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (inputTuple != null && inputTuple.size() > 0) {
            DoublesUnion union = this.unionBuilder_.build();
            DataBag bag = (DataBag)inputTuple.get(0);
            for (Tuple innerTuple : bag) {
                Object value = innerTuple.get(0);
                if (value == null) continue;
                union.update(((Double)value).doubleValue());
            }
            UpdateDoublesSketch resultSketch = union.getResultAndReset();
            if (resultSketch != null) {
                return tupleFactory_.newTuple((Object)new DataByteArray(resultSketch.toByteArray(true)));
            }
        }
        return tupleFactory_.newTuple((Object)new DataByteArray(this.unionBuilder_.build().getResult().toByteArray(true)));
    }

    public Schema outputSchema(Schema input) {
        if (input == null) {
            return null;
        }
        try {
            Schema tupleSchema = new Schema();
            tupleSchema.add(new Schema.FieldSchema("Sketch", 50));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (inputTuple == null || inputTuple.size() == 0) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            return;
        }
        if (this.accumUnion_ == null) {
            this.accumUnion_ = this.unionBuilder_.build();
        }
        for (Tuple innerTuple : bag) {
            Object value = innerTuple.get(0);
            if (value == null) continue;
            this.accumUnion_.update(((Double)value).doubleValue());
        }
    }

    public Tuple getValue() {
        UpdateDoublesSketch resultSketch;
        if (this.accumUnion_ != null && (resultSketch = this.accumUnion_.getResultAndReset()) != null) {
            return tupleFactory_.newTuple((Object)new DataByteArray(resultSketch.toByteArray(true)));
        }
        return tupleFactory_.newTuple((Object)new DataByteArray(this.unionBuilder_.build().getResult().toByteArray(true)));
    }

    public void cleanup() {
        this.accumUnion_ = null;
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return IntermediateFinal.class.getName();
    }

    public String getFinal() {
        return IntermediateFinal.class.getName();
    }

    public static class IntermediateFinal
    extends EvalFunc<Tuple> {
        private final DoublesUnionBuilder unionBuilder_ = DoublesUnion.builder();

        public IntermediateFinal() {
            this(0);
        }

        public IntermediateFinal(String kStr) {
            this(Integer.parseInt(kStr));
        }

        public IntermediateFinal(int k) {
            if (k > 0) {
                this.unionBuilder_.setMaxK(k);
            }
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            if (inputTuple != null && inputTuple.size() > 0) {
                DoublesUnion union = this.unionBuilder_.build();
                DataBag outerBag = (DataBag)inputTuple.get(0);
                for (Tuple dataTuple : outerBag) {
                    Object f0 = dataTuple.get(0);
                    if (f0 == null) continue;
                    if (f0 instanceof DataBag) {
                        DataBag innerBag = (DataBag)f0;
                        if (innerBag.size() == 0L) continue;
                        for (Tuple innerTuple : innerBag) {
                            Object value = innerTuple.get(0);
                            if (value == null) continue;
                            union.update(((Double)value).doubleValue());
                        }
                        continue;
                    }
                    if (f0 instanceof DataByteArray) {
                        DataByteArray dba = (DataByteArray)f0;
                        union.update(Memory.wrap((byte[])dba.get()));
                        continue;
                    }
                    throw new IllegalArgumentException("dataTuple.Field0: Is not a DataByteArray: " + f0.getClass().getName());
                }
                UpdateDoublesSketch resultSketch = union.getResultAndReset();
                if (resultSketch != null) {
                    return tupleFactory_.newTuple((Object)new DataByteArray(resultSketch.toByteArray(true)));
                }
            }
            return tupleFactory_.newTuple((Object)new DataByteArray(this.unionBuilder_.build().getResult().toByteArray(true)));
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        public Initial() {
        }

        public Initial(String kStr) {
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            return inputTuple;
        }
    }
}

