/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class ExtractOperatorNode
extends UnaryOperatorNode {
    private static final String[] fieldName = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND"};
    private static final String[] fieldMethod = new String[]{"getYear", "getMonth", "getDate", "getHours", "getMinutes", "getSeconds"};
    private int extractField;

    ExtractOperatorNode(int n, ValueNode valueNode, ContextManager contextManager) throws StandardException {
        super(valueNode, "EXTRACT " + fieldName[n], fieldMethod[n], contextManager);
        this.extractField = n;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.bindOperand(fromList, subqueryList, list);
        TypeId typeId = this.operand.getTypeId();
        int n = typeId.getJDBCTypeId();
        if (typeId.isStringTypeId()) {
            TypeCompiler typeCompiler = this.operand.getTypeCompiler();
            int n2 = this.extractField < 3 ? 91 : 92;
            this.operand = new CastNode(this.operand, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n2, true, typeCompiler.getCastToCharWidth(this.operand.getTypeServices())), this.getContextManager());
            ((CastNode)this.operand).bindCastNodeOnly();
            typeId = this.operand.getTypeId();
            n = typeId.getJDBCTypeId();
        }
        if (n != 91 && n != 92 && n != 93) {
            throw StandardException.newException("42X25", "EXTRACT " + fieldName[this.extractField], typeId.getSQLTypeName());
        }
        if (n == 91 && this.extractField > 2) {
            throw StandardException.newException("42X25", "EXTRACT " + fieldName[this.extractField], typeId.getSQLTypeName());
        }
        if (n == 92 && this.extractField < 3) {
            throw StandardException.newException("42X25", "EXTRACT " + fieldName[this.extractField], typeId.getSQLTypeName());
        }
        if (n == 93 && this.extractField == 5) {
            this.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), this.operand.getTypeServices().isNullable()));
        } else {
            this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.operand.getTypeServices().isNullable()));
        }
        return this;
    }

    @Override
    public String toString() {
        return "";
    }
}

