/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.XML;

public final class SecurityManagerSetup
extends TestSetup {
    static final String NO_POLICY = "<NONE>";
    public static final String DERBY_ENGINE = "derbyTesting.engine";
    public static final String DERBY_CLIENT = "derbyTesting.client";
    public static final String DERBY_SHARED = "derbyTesting.shared";
    public static final String DERBY_NETSERVER = "derbyTesting.netserver";
    public static final String DERBY_TOOLS = "derbyTesting.tools";
    public static final String DERBY_OPTIONAL_TOOLS = "derbyTesting.optionaltools";
    public static final String DERBY_TESTING = "derbyTesting.testing";
    public static final String TESTING_JUNIT = "derbyTesting.junit";
    public static final String TESTING_ANTJUNIT = "derbyTesting.antjunit";
    public static final String TESTING_ANT = "derbyTesting.ant";
    public static final String LUCENE_CORE = "derbyTesting.lucene.core";
    public static final String JAXP = "derbyTesting.jaxpjar";
    public static final String PACKAGE_PRIVATE_CLASSES = "derbyTesting.ppcodeclasses";
    public static final boolean JVM_HAS_SUBJECT_AUTHORIZATION = JDBC.haveClass("javax.security.auth.Subject");
    private static final Properties classPathSet = new Properties();
    static boolean isJars;
    private static final boolean externalSecurityManagerInstalled;
    static final boolean jacocoEnabled;
    private final String decoratorPolicyResource;
    private final String additionalPolicyResource;
    private SecurityManager decoratorSecurityManager = null;

    private static boolean checkIfJacocoIsRunning() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class.forName("org.jacoco.agent.rt.RT");
                    System.setProperty("jacoco.active", "");
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
                catch (LinkageError linkageError) {
                    return false;
                }
            }
        });
    }

    public SecurityManagerSetup(Test test, String string) {
        this(test, string, false);
    }

    public SecurityManagerSetup(Test test, String string, boolean bl) {
        super(test);
        if (bl) {
            this.decoratorPolicyResource = SecurityManagerSetup.getDefaultPolicy();
            this.additionalPolicyResource = string;
        } else {
            this.decoratorPolicyResource = string != null ? string : SecurityManagerSetup.getDefaultPolicy();
            this.additionalPolicyResource = null;
        }
    }

    public SecurityManagerSetup(Test test, String string, SecurityManager securityManager) {
        this(test, string, false);
        this.decoratorSecurityManager = securityManager;
    }

    public static Test noSecurityManager(Test test) {
        if (externalSecurityManagerInstalled) {
            return new BaseTestSuite("skipped due to external security manager " + test.toString());
        }
        return new SecurityManagerSetup(test, NO_POLICY);
    }

    static void noSecurityManager() {
        SecurityManagerSetup.installSecurityManager(NO_POLICY);
    }

    protected void setUp() throws IOException {
        String string = SecurityManagerSetup.getEffectivePolicyResource(this.decoratorPolicyResource, this.additionalPolicyResource);
        SecurityManagerSetup.installSecurityManager(string, this.decoratorSecurityManager);
    }

    protected void tearDown() throws Exception {
        if (NO_POLICY.equals(this.decoratorPolicyResource)) {
            BaseTestCase.setSystemProperty("java.security.policy", "");
        } else if (!externalSecurityManagerInstalled) {
            SecurityManagerSetup.uninstallSecurityManager();
        }
    }

    private static String getDefaultPolicy() {
        return "org/apache/derbyTesting/functionTests/util/derby_tests.policy";
    }

    static void installSecurityManager() {
        SecurityManagerSetup.installSecurityManager(SecurityManagerSetup.getDefaultPolicy());
    }

    private static void installSecurityManager(String string) {
        SecurityManagerSetup.installSecurityManager(string, System.getSecurityManager());
    }

    private static void installSecurityManager(String string, final SecurityManager securityManager) {
        String string2;
        Object object;
        if (externalSecurityManagerInstalled) {
            return;
        }
        Properties properties = new Properties(classPathSet);
        SecurityManagerSetup.setSecurityPolicy(properties, string);
        Object object2 = properties.propertyNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
        }
        object2 = System.getSecurityManager();
        if (object2 != null) {
            object = properties.getProperty("java.security.policy");
            if (object == null) {
                object = "";
            }
            string2 = BaseTestCase.getSystemProperty("java.security.policy");
            SecurityManager securityManager2 = System.getSecurityManager();
            if (string2 == null) {
                string2 = "";
            }
            if (((String)object).equals(string2) && securityManager2 == securityManager) {
                return;
            }
            SecurityManagerSetup.uninstallSecurityManager();
        }
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            string2 = (String)object.nextElement();
            BaseTestCase.setSystemProperty(string2, properties.getProperty(string2));
        }
        if (NO_POLICY.equals(properties.getProperty("java.security.policy"))) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (securityManager == null) {
                    System.setSecurityManager(new SecurityManager());
                } else {
                    System.setSecurityManager(securityManager);
                }
                Policy.getPolicy().refresh();
                return null;
            }
        });
        SecurityManagerSetup.println("installed policy " + string);
    }

    private static void setSecurityPolicy(Properties properties, String string) {
        if (NO_POLICY.equals(string)) {
            properties.setProperty("java.security.policy", string);
            return;
        }
        try {
            URL uRL = SecurityManagerSetup.getResourceURL(string);
            properties.setProperty("java.security.policy", uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            BaseTestCase.alarm("Unreadable policy URL: " + string);
        }
    }

    private static boolean determineClasspath() {
        boolean bl;
        URL uRL;
        if (System.getSecurityManager() != null) {
            return true;
        }
        SecurityManagerSetup.setCodebase(TESTING_JUNIT, SecurityManagerSetup.getURL(Test.class));
        SecurityManagerSetup.setCodebase(TESTING_ANTJUNIT, "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
        SecurityManagerSetup.setCodebase(TESTING_ANT, "org.apache.tools.ant.Task");
        URL uRL2 = SecurityManagerSetup.getURL("org.apache.lucene.store.FSDirectory");
        if (uRL2 != null) {
            SecurityManagerSetup.setCodebase(LUCENE_CORE, uRL2);
            classPathSet.setProperty("derbyTesting.lucene.core.jar.file", uRL2.getFile());
        }
        if ((uRL = SecurityManagerSetup.getURL("com.vladium.emma.EMMAException")) != null) {
            classPathSet.setProperty("emma.active", "");
        }
        SecurityManagerSetup.setCodebase(JAXP, XML.getJAXPParserLocation());
        URL uRL3 = SecurityManagerSetup.getURL(SecurityManagerSetup.class);
        URL uRL4 = null;
        if (BaseTestCase.getClassVersionMajor() >= 49) {
            uRL4 = SecurityManagerSetup.getURL("org.apache.derby.PackagePrivateTestSuite");
        }
        if (bl = uRL3.toExternalForm().endsWith("/")) {
            SecurityManagerSetup.setCodebase(PACKAGE_PRIVATE_CLASSES, uRL4);
            isJars = false;
        } else {
            isJars = true;
        }
        SecurityManagerSetup.setCodebase(DERBY_TESTING, uRL3);
        if (uRL3.getProtocol().equals("file")) {
            File file = new File(uRL3.getPath());
            classPathSet.setProperty("derbyTesting.testjarpath", file.getAbsolutePath());
            classPathSet.setProperty("derby.install.path", file.getParentFile().getAbsolutePath());
        }
        SecurityManagerSetup.setCodebase(DERBY_ENGINE, "org.apache.derby.database.Database");
        SecurityManagerSetup.setCodebase(DERBY_CLIENT, "org.apache.derby.client.ClientAutoloadedDriver");
        SecurityManagerSetup.setCodebase(DERBY_SHARED, "org.apache.derby.shared.common.error.MessageUtils");
        SecurityManagerSetup.setCodebase(DERBY_NETSERVER, "org.apache.derby.drda.NetworkServerControl");
        SecurityManagerSetup.setCodebase(DERBY_TOOLS, "org.apache.derby.tools.ij");
        SecurityManagerSetup.setCodebase(DERBY_OPTIONAL_TOOLS, "org.apache.derby.optional.utils.ToolUtilities");
        return false;
    }

    private static void setCodebase(String string, String string2) {
        if (string2 != null) {
            SecurityManagerSetup.setCodebase(string, SecurityManagerSetup.getURL(string2));
        }
    }

    private static void setCodebase(String string, URL uRL) {
        if (uRL != null) {
            classPathSet.setProperty(string, uRL.toExternalForm());
        }
    }

    public static Properties getPolicyFilePropertiesForOldHarness() {
        return classPathSet;
    }

    public static URL getURL(String string) {
        try {
            return SecurityManagerSetup.getURL(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    static URL getURL(final Class clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                if (clazz.getProtectionDomain().getCodeSource() == null) {
                    return null;
                }
                return clazz.getProtectionDomain().getCodeSource().getLocation();
            }
        });
    }

    private static void uninstallSecurityManager() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setSecurityManager(null);
                return null;
            }
        });
    }

    private static String getEffectivePolicyResource(String string, String string2) throws IOException {
        String string3 = string;
        if (!NO_POLICY.equals(string3)) {
            URL uRL = SecurityManagerSetup.getResourceURL(string);
            string3 = uRL.toExternalForm();
            if (string2 != null) {
                URL uRL2 = SecurityManagerSetup.getResourceURL(string2);
                if (!uRL.toExternalForm().equals(uRL2.toExternalForm())) {
                    string3 = SecurityManagerSetup.mergePolicies(uRL, uRL2);
                }
            }
        }
        return string3;
    }

    private static URL getResourceURL(String string) throws MalformedURLException {
        URL uRL = BaseTestCase.getTestResource(string);
        if (uRL == null) {
            uRL = new URL(string);
        }
        return uRL;
    }

    private static String mergePolicies(URL uRL, URL uRL2) throws IOException {
        int n;
        String string = BaseTestCase.getSystemProperty("derby.system.home");
        File file = new File(string == null ? "system" : string);
        File file2 = new File(file, "var");
        SecurityManagerSetup.mkdir(file);
        SecurityManagerSetup.mkdir(file2);
        final File file3 = new File(file2, new File(uRL2.getPath()).getName() + "-MERGED_WITH-" + new File(uRL.getPath()).getName());
        FileOutputStream fileOutputStream = PrivilegedFileOpsForTests.getFileOutputStream(file3);
        byte[] byArray = new byte[1024];
        InputStream inputStream = SecurityManagerSetup.openStream(uRL);
        while ((n = inputStream.read(byArray)) != -1) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream.close();
        InputStream inputStream2 = SecurityManagerSetup.openStream(uRL2);
        while ((n = inputStream2.read(byArray)) != -1) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream2.close();
        ((OutputStream)fileOutputStream).close();
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws MalformedURLException {
                    return file3.toURI().toURL().toExternalForm();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (MalformedURLException)privilegedActionException.getException();
        }
    }

    private static InputStream openStream(final URL uRL) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return uRL.openStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private static void mkdir(final File file) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (!file.exists() && !file.mkdir()) {
                    Assert.fail((String)("failed to create directory: " + file.getPath()));
                }
                return null;
            }
        });
    }

    private static void println(String string) {
        BaseTestCase.println("{SecurityManagerSetup} " + string);
    }

    static {
        externalSecurityManagerInstalled = SecurityManagerSetup.determineClasspath();
        if (BaseTestCase.isJ9Platform()) {
            BaseTestCase.setSystemProperty("emma.active", "");
            BaseTestCase.setSystemProperty("jacoco.active", "");
        }
        jacocoEnabled = SecurityManagerSetup.checkIfJacocoIsRunning();
    }
}

