/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Jar {
    public static void doJars(String dbName, Connection conn, boolean at10_9) throws SQLException {
        String separator = System.getProperty("file.separator");
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT FILENAME, SCHEMAID, GENERATIONID, FILEID FROM SYS.SYSFILES");
        boolean firstTime = true;
        while (rs.next()) {
            File jarDir;
            String absJarDir;
            StringBuffer oldJarPath;
            StringBuffer jarFullName;
            StringBuffer loadJarString = new StringBuffer();
            String jarName = rs.getString(1);
            String schemaId = rs.getString(2);
            String genID = rs.getString(3);
            String UUIDstring = rs.getString(4);
            String schemaNameSQL = dblook.lookupSchemaId(schemaId);
            if (dblook.isIgnorableSchema(schemaNameSQL)) continue;
            DB_Jar.doHeader(firstTime);
            if (at10_9) {
                String schemaNameCNF = dblook.unExpandDoubleQuotes(dblook.stripQuotes(dblook.lookupSchemaId(schemaId)));
                jarFullName = new StringBuffer();
                jarFullName.append(UUIDstring);
                jarFullName.append(".jar.G");
                jarFullName.append(genID);
                oldJarPath = new StringBuffer();
                oldJarPath.append(dbName);
                oldJarPath.append(separator);
                oldJarPath.append("jar");
                oldJarPath.append(separator);
                oldJarPath.append(jarFullName.toString());
                absJarDir = null;
                try {
                    jarDir = new File(System.getProperty("user.dir") + separator + "DBJARS");
                    absJarDir = jarDir.getAbsolutePath();
                    jarDir.mkdirs();
                    DB_Jar.doCopy(oldJarPath.toString(), absJarDir + separator + jarFullName);
                }
                catch (Exception e) {
                    Logs.debug("DBLOOK_FailedToLoadJar", absJarDir + separator + jarFullName.toString());
                    Logs.debug(e);
                    firstTime = false;
                    continue;
                }
                loadJarString.append("CALL SQLJ.INSTALL_JAR('file:");
                loadJarString.append(absJarDir);
                loadJarString.append(separator);
                loadJarString.append(jarFullName);
                loadJarString.append("', '");
                loadJarString.append(dblook.addQuotes(dblook.expandDoubleQuotes(schemaNameCNF)));
                loadJarString.append(".");
                loadJarString.append(dblook.addQuotes(dblook.expandDoubleQuotes(jarName)));
            } else {
                jarName = dblook.addQuotes(dblook.expandDoubleQuotes(jarName));
                String schemaWithoutQuotes = dblook.stripQuotes(schemaNameSQL);
                jarFullName = new StringBuffer(separator);
                jarFullName.append(dblook.stripQuotes(jarName));
                jarFullName.append(".jar.G");
                jarFullName.append(genID);
                oldJarPath = new StringBuffer();
                oldJarPath.append(dbName);
                oldJarPath.append(separator);
                oldJarPath.append("jar");
                oldJarPath.append(separator);
                oldJarPath.append(schemaWithoutQuotes);
                oldJarPath.append(jarFullName);
                absJarDir = null;
                try {
                    jarDir = new File(System.getProperty("user.dir") + separator + "DBJARS" + separator + schemaWithoutQuotes);
                    absJarDir = jarDir.getAbsolutePath();
                    jarDir.mkdirs();
                    DB_Jar.doCopy(oldJarPath.toString(), absJarDir + jarFullName);
                }
                catch (Exception e) {
                    Logs.debug("DBLOOK_FailedToLoadJar", absJarDir + jarFullName.toString());
                    Logs.debug(e);
                    firstTime = false;
                    continue;
                }
                loadJarString.append("CALL SQLJ.INSTALL_JAR('file:");
                loadJarString.append(absJarDir);
                loadJarString.append(jarFullName);
                loadJarString.append("', '");
                loadJarString.append(schemaNameSQL);
                loadJarString.append(".");
                loadJarString.append(jarName);
            }
            loadJarString.append("', 0)");
            Logs.writeToNewDDL(loadJarString.toString());
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        stmt.close();
        rs.close();
    }

    private static void doHeader(boolean firstTime) {
        if (firstTime) {
            Logs.reportString("----------------------------------------------");
            Logs.reportMessage("DBLOOK_JarsHeader");
            Logs.reportMessage("DBLOOK_Jar_Note");
            Logs.reportString("----------------------------------------------\n");
        }
    }

    private static void doCopy(String oldJarFileName, String newJarFileName) throws IOException {
        FileInputStream oldJarFile = new FileInputStream(oldJarFileName);
        FileOutputStream newJarFile = new FileOutputStream(newJarFileName);
        while (oldJarFile.available() != 0) {
            byte[] bAr = new byte[oldJarFile.available()];
            oldJarFile.read(bAr);
            newJarFile.write(bAr);
        }
        oldJarFile.close();
        newJarFile.close();
    }
}

