/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby5165Test
extends BaseJDBCTestCase {
    public Derby5165Test(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3()) {
            Test test = TestConfiguration.embeddedSuite(Derby5165Test.class);
            test = DatabasePropertyTestSetup.setLockTimeouts(test, 2, 4);
            test = TestConfiguration.singleUseDatabaseDecorator(test, "d5165db");
            test = TestConfiguration.singleUseDatabaseDecorator(test, "d5165db2");
            test = TestConfiguration.singleUseDatabaseDecorator(test, "d5165db3");
            test = TestConfiguration.singleUseDatabaseDecorator(test, "d5165db4");
            return test;
        }
        return new BaseTestSuite("Derby5165Test cannot run without XA support");
    }

    public void testXAUpdateLockKeptPastDBRestart() throws InterruptedException, SQLException, XAException {
        Wrapper wrapper;
        if (Derby5165Test.usingDerbyNetClient()) {
            return;
        }
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "d5165db");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Connection connection = xAConnection.getConnection();
        Statement statement = connection.createStatement();
        String string = "d5165t";
        this.createAndLoadTable(connection, string, true);
        connection.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from " + string), "1");
        connection.close();
        statement.close();
        MyXid myXid = new MyXid(1, 2, 3);
        xAResource.start(myXid, 0);
        Connection connection2 = xAConnection.getConnection();
        Statement statement2 = connection2.createStatement();
        statement2.execute("update " + string + " set x = 2 where x = 1");
        xAResource.end(myXid, 0x4000000);
        xAResource.prepare(myXid);
        try {
            wrapper = JDBCDataSource.getDataSource("d5165db");
            JDBCDataSource.shutdownDatabase((DataSource)wrapper);
        }
        catch (Exception exception) {
            // empty catch block
        }
        wrapper = this.openConnection("d5165db");
        Statement statement3 = wrapper.createStatement();
        try {
            ResultSet resultSet = statement3.executeQuery("select * from " + string);
            while (resultSet.next()) {
                resultSet.getInt(1);
            }
            resultSet.close();
            Derby5165Test.fail((String)"expected a timeout");
        }
        catch (SQLException sQLException) {
            Derby5165Test.assertSQLState("40XL1", sQLException);
        }
        statement.close();
        wrapper.close();
        statement3.close();
        xAConnection.close();
    }

    public void testXAInsertLockKeptPastDBRestart() throws InterruptedException, SQLException, XAException {
        Wrapper wrapper;
        if (Derby5165Test.usingDerbyNetClient()) {
            return;
        }
        Connection connection = this.openConnection("d5165db2");
        connection.close();
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "d5165db2");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Connection connection2 = xAConnection.getConnection();
        Statement statement = connection2.createStatement();
        String string = "d5165t";
        this.createAndLoadTable(connection2, string, true);
        connection2.commit();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from " + string), "1");
        connection2.close();
        statement.close();
        MyXid myXid = new MyXid(1, 2, 3);
        xAResource.start(myXid, 0);
        Connection connection3 = xAConnection.getConnection();
        Statement statement2 = connection3.createStatement();
        statement2.execute("insert into " + string + " values 2");
        xAResource.end(myXid, 0x4000000);
        xAResource.prepare(myXid);
        try {
            wrapper = JDBCDataSource.getDataSource("d5165db2");
            JDBCDataSource.shutdownDatabase((DataSource)wrapper);
        }
        catch (Exception exception) {
            // empty catch block
        }
        wrapper = this.openConnection("d5165db2");
        Statement statement3 = wrapper.createStatement();
        try {
            ResultSet resultSet = statement3.executeQuery("select * from " + string);
            while (resultSet.next()) {
                resultSet.getInt(1);
            }
            resultSet.close();
            Derby5165Test.fail((String)"expected a timeout");
        }
        catch (SQLException sQLException) {
            Derby5165Test.assertSQLState("40XL1", sQLException);
        }
        statement.close();
        wrapper.close();
        statement3.close();
        xAConnection.close();
    }

    public void testXAUpdateLockKeptPastCrashedDBRestart() throws Exception {
        Derby5165Test.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby5165Test.launchUpdate", "d5165db3");
        Derby5165Test.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby5165Test.checkUpdate", "d5165db3");
    }

    public void testXAInsertLockKeptPastCrashedDBRestart() throws Exception {
        Derby5165Test.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby5165Test.launchInsert", "d5165db4");
        Derby5165Test.assertLaunchedJUnitTestMethod("org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby5165Test.checkInsert", "d5165db4");
    }

    public void launchUpdate() throws Exception {
        Connection connection = this.getConnection();
        this.setAutoCommit(false);
        String string = "d5165t2";
        this.createAndLoadTable(connection, string, true);
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "d5165db3");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Connection connection2 = xAConnection.getConnection();
        Statement statement = connection2.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from " + string), "1");
        connection2.close();
        statement.close();
        MyXid myXid = new MyXid(1, 2, 3);
        xAResource.start(myXid, 0);
        Connection connection3 = xAConnection.getConnection();
        Statement statement2 = connection3.createStatement();
        statement2.execute("update " + string + " set x = 2 where x = 1");
        xAResource.end(myXid, 0x4000000);
        xAResource.prepare(myXid);
    }

    public void checkUpdate() throws Exception {
        String string = "d5165t2";
        Connection connection = this.getConnection();
        this.setAutoCommit(false);
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("select * from " + string);
            while (resultSet.next()) {
                resultSet.getInt(1);
            }
            resultSet.close();
            Derby5165Test.fail((String)"expected a timeout");
        }
        catch (SQLException sQLException) {
            Derby5165Test.assertSQLState("40XL1", sQLException);
        }
    }

    public void launchInsert() throws Exception {
        String string = "d5165t3";
        Connection connection = this.getConnection();
        this.setAutoCommit(false);
        this.createAndLoadTable(connection, string, true);
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "d5165db4");
        XAConnection xAConnection = xADataSource.getXAConnection();
        XAResource xAResource = xAConnection.getXAResource();
        Connection connection2 = xAConnection.getConnection();
        Statement statement = connection2.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from " + string), "1");
        connection2.close();
        statement.close();
        MyXid myXid = new MyXid(1, 2, 3);
        xAResource.start(myXid, 0);
        Connection connection3 = xAConnection.getConnection();
        Statement statement2 = connection3.createStatement();
        statement2.execute("insert into " + string + " values 2");
        xAResource.end(myXid, 0x4000000);
        xAResource.prepare(myXid);
    }

    public void checkInsert() throws Exception {
        String string = "d5165t3";
        Connection connection = this.getConnection();
        this.setAutoCommit(false);
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("select * from " + string);
            while (resultSet.next()) {
                resultSet.getInt(1);
            }
            resultSet.close();
            Derby5165Test.fail((String)"expected a timeout");
        }
        catch (SQLException sQLException) {
            Derby5165Test.assertSQLState("40XL1", sQLException);
        }
    }

    private void createAndLoadTable(Connection connection, String string, boolean bl) throws SQLException {
        if (bl) {
            Statement statement = connection.createStatement();
            statement.executeUpdate("create table " + string + "(x int)");
            statement.executeUpdate("insert into " + string + " values 1");
            connection.commit();
            JDBC.assertSingleValueResultSet(statement.executeQuery("select * from " + string), "1");
            statement.close();
            Derby5165Test.println("table created: " + string);
        }
    }

    private static class MyXid
    implements Xid {
        int formatId;
        byte txid;
        byte bq;

        MyXid(int n, int n2, int n3) {
            this.formatId = n;
            this.txid = (byte)n2;
            this.bq = (byte)n3;
        }

        @Override
        public int getFormatId() {
            return this.formatId;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return new byte[]{this.txid};
        }

        @Override
        public byte[] getBranchQualifier() {
            return new byte[]{this.bq};
        }
    }
}

