/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.services.T_CacheException;
import org.apache.derbyTesting.unitTests.services.T_CacheService;
import org.apache.derbyTesting.unitTests.services.T_Cacheable;
import org.apache.derbyTesting.unitTests.services.T_Key;

public class T_CacheUser
implements Runnable {
    protected CacheManager cm;
    protected int iterations;
    protected HeaderPrintWriter out;
    protected T_CacheService parent;

    public T_CacheUser(CacheManager cm, int iterations, T_CacheService parent, HeaderPrintWriter out) {
        this.cm = cm;
        this.iterations = iterations;
        this.parent = parent;
        this.out = out;
    }

    @Override
    public void run() {
        try {
            this.thrashCache();
        }
        catch (T_Fail tf) {
            this.parent.setChildException(tf);
        }
        catch (StandardException se) {
            this.parent.setChildException(T_Fail.exceptionFail(se));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void thrashCache() throws StandardException, T_Fail {
        int f = 0;
        int fs = 0;
        int ff = 0;
        int fe = 0;
        int fc = 0;
        int fcs = 0;
        int fcf = 0;
        int c = 0;
        int cs = 0;
        int cf = 0;
        int ce = 0;
        int cse = 0;
        int cleanAll = 0;
        int ageOut = 0;
        int release = 0;
        int remove = 0;
        for (int i = 0; i < this.iterations; ++i) {
            T_Cacheable e;
            T_Key tkey;
            block24: {
                if (i % 100 == 0) {
                    this.out.printlnWithHeader("iteration " + i);
                }
                tkey = T_Key.randomKey();
                double rand = Math.random();
                e = null;
                if (rand < 0.5) {
                    ++f;
                    try {
                        e = (T_Cacheable)this.cm.find((Object)tkey);
                        if (e == null) {
                            ++ff;
                            continue;
                        }
                        ++fs;
                        break block24;
                    }
                    catch (T_CacheException tc) {
                        if (tc.getType() == 0) {
                            throw tc;
                        }
                        ++fe;
                        continue;
                    }
                }
                if (rand < 0.8) {
                    ++fc;
                    e = (T_Cacheable)this.cm.findCached((Object)tkey);
                    if (e == null) {
                        ++fcf;
                        continue;
                    }
                    ++fcs;
                } else {
                    ++c;
                    try {
                        e = (T_Cacheable)this.cm.create((Object)tkey, (Object)Thread.currentThread());
                        if (e == null) {
                            ++cf;
                            continue;
                        }
                        ++cs;
                    }
                    catch (T_CacheException tc) {
                        if (tc.getType() == 0) {
                            throw tc;
                        }
                        ++ce;
                        continue;
                    }
                    catch (StandardException se) {
                        if (se.getMessageId().equals("XBCA0.S")) {
                            ++cse;
                            continue;
                        }
                        throw se;
                    }
                }
            }
            this.cm.release(this.parent.t_findCachedSucceed(this.cm, tkey));
            if (Math.random() < 0.25) {
                e.setDirty();
            }
            if (Math.random() < 0.75) {
                Thread.yield();
            }
            if (Math.random() < 0.1 && e.canRemove()) {
                ++remove;
                this.cm.remove((Cacheable)e);
            } else {
                ++release;
                this.cm.release((Cacheable)e);
            }
            e = null;
            double rand2 = Math.random();
            if (rand2 < 0.02) {
                ++cleanAll;
                this.cm.cleanAll();
                continue;
            }
            if (!(rand2 < 0.04)) continue;
            ++ageOut;
            this.cm.ageOut();
        }
        T_CacheService t_CacheService = this.parent;
        synchronized (t_CacheService) {
            this.out.printlnWithHeader("find()       calls " + f + " : found/not found/exception : " + fs + "/" + ff + "/" + fe);
            this.out.printlnWithHeader("findCached() calls " + fc + " : found/not found           : " + fcs + "/" + fcf);
            this.out.printlnWithHeader("create()     calls " + c + " : found/not found/exception/standard exception : " + cs + "/" + cf + "/" + ce + "/" + cse);
            this.out.printlnWithHeader("release()    calls " + release);
            this.out.printlnWithHeader("remove()     calls " + remove);
            this.out.printlnWithHeader("cleanAll()   calls " + cleanAll);
            this.out.printlnWithHeader("ageOut()     calls " + ageOut);
        }
    }
}

