/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.persistentSearch;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchContainer;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchStates;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistentSearchGrammar
extends AbstractGrammar<PersistentSearchContainer> {
    static final Logger LOG = LoggerFactory.getLogger(PersistentSearchGrammar.class);
    private static Grammar<?> instance = new PersistentSearchGrammar();

    private PersistentSearchGrammar() {
        this.setName(PersistentSearchGrammar.class.getName());
        this.transitions = new GrammarTransition[PersistentSearchStates.LAST_PSEARCH_STATE.ordinal()][256];
        this.transitions[PersistentSearchStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(PersistentSearchStates.START_STATE, PersistentSearchStates.PSEARCH_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[PersistentSearchStates.PSEARCH_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<PersistentSearchContainer>(PersistentSearchStates.PSEARCH_SEQUENCE_STATE, PersistentSearchStates.CHANGE_TYPES_STATE, UniversalTag.INTEGER.getValue(), new GrammarAction<PersistentSearchContainer>("Set PSearchControl changeTypes"){

            @Override
            public void action(PersistentSearchContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int changeTypes = IntegerDecoder.parse(value, PersistentSearch.CHANGE_TYPES_MIN, PersistentSearch.CHANGE_TYPES_MAX);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_05304_CHANGE_TYPES, changeTypes));
                    }
                    container.getPersistentSearch().setChangeTypes(changeTypes);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_05307_CHANGE_TYPES_DECODING_ERROR, new Object[0]);
                    LOG.error(msg, ide);
                    throw new DecoderException(msg, ide);
                }
            }
        });
        this.transitions[PersistentSearchStates.CHANGE_TYPES_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<PersistentSearchContainer>(PersistentSearchStates.CHANGE_TYPES_STATE, PersistentSearchStates.CHANGES_ONLY_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<PersistentSearchContainer>("Set PSearchControl changesOnly"){

            @Override
            public void action(PersistentSearchContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean changesOnly = BooleanDecoder.parse(value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_05305_CHANGES_ONLY, changesOnly));
                    }
                    container.getPersistentSearch().setChangesOnly(changesOnly);
                }
                catch (BooleanDecoderException bde) {
                    String msg = I18n.err(I18n.ERR_05308_CHANGE_ONLY_DECODING_ERROR, new Object[0]);
                    LOG.error(msg, bde);
                    throw new DecoderException(msg, bde);
                }
            }
        });
        this.transitions[PersistentSearchStates.CHANGES_ONLY_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<PersistentSearchContainer>(PersistentSearchStates.CHANGES_ONLY_STATE, PersistentSearchStates.RETURN_ECS_STATE, UniversalTag.BOOLEAN.getValue(), new GrammarAction<PersistentSearchContainer>("Set PSearchControl returnECs"){

            @Override
            public void action(PersistentSearchContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean returnECs = BooleanDecoder.parse(value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_05306_RETURN_ECS, returnECs));
                    }
                    container.getPersistentSearch().setReturnECs(returnECs);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException bde) {
                    String msg = I18n.err(I18n.ERR_05309_RETURN_ECS_DECODING_ERROR, new Object[0]);
                    LOG.error(msg, bde);
                    throw new DecoderException(msg, bde);
                }
            }
        });
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

