/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.event.SaveModelEvent;
import org.apache.directory.fortress.web.model.OUListModel;
import org.apache.directory.fortress.web.panel.OUListPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OUListPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)OUListPanel.class.getName());
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private String searchVal;

    public OUListPanel(String id, boolean isUser) {
        super(id);
        String searchLabel;
        OrgUnit orgUnit = new OrgUnit();
        orgUnit.setName("");
        if (isUser) {
            orgUnit.setType(OrgUnit.Type.USER);
            searchLabel = "User OU Name";
        } else {
            orgUnit.setType(OrgUnit.Type.PERM);
            searchLabel = "Perm OU Name";
        }
        OUListModel ouListModel = new OUListModel(orgUnit, SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)ouListModel);
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        PropertyColumn name = new PropertyColumn((IModel)Model.of((Serializable)((Object)searchLabel)), "userObject.name");
        name.setInitialSize(400);
        columns.add(name);
        PropertyColumn description = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Description")), "userObject.Description");
        description.setInitialSize(400);
        columns.add(description);
        PropertyColumn parents = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Parents")), "userObject.parents");
        parents.setInitialSize(400);
        columns.add(parents);
        List orgUnits = (List)this.getDefaultModel().getObject();
        this.treeModel = this.createTreeModel(orgUnits);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        Form listForm = new Form("form");
        listForm.add(new Component[]{this.grid});
        this.grid.setOutputMarkupId(true);
        TextField searchValFld = new TextField("searchVal", (IModel)new PropertyModel((Object)this, "searchVal"));
        listForm.add(new Component[]{searchValFld});
        listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{listForm});
    }

    public void onEvent(IEvent event) {
        if (event.getPayload() instanceof SaveModelEvent) {
            SaveModelEvent modelEvent = (SaveModelEvent)event.getPayload();
            switch (3.$SwitchMap$org$apache$directory$fortress$web$event$SaveModelEvent$Operations[modelEvent.getOperation().ordinal()]) {
                case 1: {
                    this.add(modelEvent.getEntity());
                    break;
                }
                case 2: {
                    this.modelChanged();
                    break;
                }
                case 3: {
                    this.prune();
                    break;
                }
            }
            AjaxRequestTarget target = ((SaveModelEvent)event.getPayload()).getAjaxRequestTarget();
            target.add(new Component[]{this.grid});
            LOG.debug(".onEvent SaveModelEvent: " + target.toString());
        }
    }

    private void removeSelectedItems(TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid) {
        Collection selected = grid.getSelectedItems();
        for (IModel model : selected) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getObject();
            this.treeModel.removeNodeFromParent(node);
            OrgUnit orgUnit = (OrgUnit)node.getUserObject();
            LOG.debug(".removeSelectedItems ou node: " + orgUnit.getName());
            List orgUnits = (List)this.getDefaultModel().getObject();
            orgUnits.remove(orgUnit);
        }
    }

    private DefaultTreeModel createTreeModel(List<OrgUnit> orgUnits) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (orgUnits == null) {
            LOG.debug("no OrgUnits found");
        } else {
            LOG.debug("OrgUnits found:" + orgUnits.size());
            for (OrgUnit orgUnit : orgUnits) {
                this.rootNode.add(new DefaultMutableTreeNode(orgUnit));
            }
        }
        return model;
    }

    public void add(FortEntity entity) {
        if (this.getDefaultModelObject() != null) {
            List orgUnits = (List)this.getDefaultModelObject();
            orgUnits.add((OrgUnit)entity);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(entity), this.rootNode, orgUnits.size());
        }
    }

    public void prune() {
        this.removeSelectedItems(this.grid);
    }
}

