/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.features.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.karaf.commons.osgi.VersionRange;
import org.apache.felix.karaf.features.Feature;
import org.apache.felix.karaf.features.FeatureEvent;
import org.apache.felix.karaf.features.FeaturesListener;
import org.apache.felix.karaf.features.FeaturesService;
import org.apache.felix.karaf.features.Repository;
import org.apache.felix.karaf.features.RepositoryEvent;
import org.apache.felix.karaf.features.internal.FeatureImpl;
import org.apache.felix.karaf.features.internal.HeaderParser;
import org.apache.felix.karaf.features.internal.RepositoryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;
import org.osgi.service.startlevel.StartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturesServiceImpl
implements FeaturesService {
    public static final String CONFIG_KEY = "org.apache.felix.karaf.features.configKey";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesServiceImpl.class);
    private BundleContext bundleContext;
    private ConfigurationAdmin configAdmin;
    private PackageAdmin packageAdmin;
    private StartLevel startLevel;
    private PreferencesService preferences;
    private Set<URI> uris;
    private Map<URI, RepositoryImpl> repositories = new HashMap<URI, RepositoryImpl>();
    private Map<String, Map<String, Feature>> features;
    private Map<Feature, Set<Long>> installed = new HashMap<Feature, Set<Long>>();
    private String boot;
    private boolean bootFeaturesInstalled;
    private List<FeaturesListener> listeners = new CopyOnWriteArrayList<FeaturesListener>();
    static Pattern fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);
    static Pattern fuzzyModifier = Pattern.compile("(\\d+[.-])*(.*)", 32);

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public PackageAdmin getPackageAdmin() {
        return this.packageAdmin;
    }

    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public PreferencesService getPreferences() {
        return this.preferences;
    }

    public void setPreferences(PreferencesService preferences) {
        this.preferences = preferences;
    }

    public StartLevel getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(StartLevel startLevel) {
        this.startLevel = startLevel;
    }

    public void registerListener(FeaturesListener listener) {
        this.listeners.add(listener);
        for (Repository repository : this.listRepositories()) {
            listener.repositoryEvent(new RepositoryEvent(repository, RepositoryEvent.EventType.RepositoryAdded, true));
        }
        for (Feature feature : this.listInstalledFeatures()) {
            listener.featureEvent(new FeatureEvent(feature, FeatureEvent.EventType.FeatureInstalled, true));
        }
    }

    public void unregisterListener(FeaturesListener listener) {
        this.listeners.remove(listener);
    }

    public void setUrls(String uris) throws URISyntaxException {
        String[] s = uris.split(",");
        this.uris = new HashSet<URI>();
        for (String value : s) {
            this.uris.add(new URI(value));
        }
    }

    public void setBoot(String boot) {
        this.boot = boot;
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        if (!this.repositories.containsKey(uri)) {
            this.internalAddRepository(uri);
            this.saveState();
        }
    }

    protected RepositoryImpl internalAddRepository(URI uri) throws Exception {
        RepositoryImpl repo = null;
        repo = new RepositoryImpl(uri);
        repo.load();
        this.repositories.put(uri, repo);
        this.callListeners(new RepositoryEvent(repo, RepositoryEvent.EventType.RepositoryAdded, false));
        this.features = null;
        return repo;
    }

    @Override
    public void removeRepository(URI uri) {
        if (this.repositories.containsKey(uri)) {
            this.internalRemoveRepository(uri);
            this.saveState();
        }
    }

    public void internalRemoveRepository(URI uri) {
        Repository repo = this.repositories.remove(uri);
        this.callListeners(new RepositoryEvent(repo, RepositoryEvent.EventType.RepositoryRemoved, false));
        this.features = null;
    }

    @Override
    public Repository[] listRepositories() {
        Collection<RepositoryImpl> repos = this.repositories.values();
        return repos.toArray(new Repository[repos.size()]);
    }

    public void installAllFeatures(URI uri) throws Exception {
        RepositoryImpl repo = this.internalAddRepository(uri);
        for (Feature f : repo.getFeatures()) {
            this.installFeature(f.getName(), f.getVersion());
        }
        this.internalRemoveRepository(uri);
    }

    public void uninstallAllFeatures(URI uri) throws Exception {
        RepositoryImpl repo = this.internalAddRepository(uri);
        for (Feature f : repo.getFeatures()) {
            this.uninstallFeature(f.getName(), f.getVersion());
        }
        this.internalRemoveRepository(uri);
    }

    @Override
    public void installFeature(String name) throws Exception {
        this.installFeature(name, FeatureImpl.DEFAULT_VERSION);
    }

    @Override
    public void installFeature(String name, String version) throws Exception {
        this.installFeature(name, version, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void installFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        Feature f = this.getFeature(name, version);
        if (f == null) {
            throw new Exception("No feature named '" + name + "' with version '" + version + "' available");
        }
        this.installFeature(f, options);
    }

    @Override
    public void installFeature(Feature f, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeatures(Collections.singleton(f), options);
    }

    @Override
    public void installFeatures(Set<Feature> features, EnumSet<FeaturesService.Option> options) throws Exception {
        InstallationState state = new InstallationState();
        InstallationState failure = new InstallationState();
        try {
            boolean bl;
            for (Feature feature : features) {
                InstallationState s = new InstallationState();
                try {
                    this.doInstallFeature(s, feature);
                    state.bundles.addAll(s.bundles);
                    state.features.putAll(s.features);
                    state.installed.addAll(s.installed);
                }
                catch (Exception e) {
                    failure.bundles.addAll(s.bundles);
                    failure.features.putAll(s.features);
                    failure.installed.addAll(s.installed);
                    if (options.contains((Object)FeaturesService.Option.ContinueBatchOnFailure)) {
                        LOGGER.info("Error when installing feature {}: {}", (Object)feature.getName(), (Object)e);
                        continue;
                    }
                    throw e;
                }
            }
            boolean print = options.contains((Object)FeaturesService.Option.PrintBundlesToRefresh);
            boolean bl2 = bl = !options.contains((Object)FeaturesService.Option.NoAutoRefreshBundles);
            if (print || bl) {
                Set<Bundle> bundlesToRefresh = this.findBundlesToRefresh(state);
                StringBuilder sb = new StringBuilder();
                for (Bundle b : bundlesToRefresh) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(b.getSymbolicName()).append(" (").append(b.getBundleId()).append(")");
                }
                LOGGER.info("Bundles to refresh: {}", (Object)sb.toString());
                if (!bundlesToRefresh.isEmpty()) {
                    if (print) {
                        if (bl) {
                            System.out.println("Refreshing bundles " + sb.toString());
                        } else {
                            System.out.println("The following bundles may need to be refreshed: " + sb.toString());
                        }
                    }
                    if (bl) {
                        LOGGER.info("Refreshing bundles: {}", (Object)sb.toString());
                        this.getPackageAdmin().refreshPackages(bundlesToRefresh.toArray(new Bundle[bundlesToRefresh.size()]));
                    }
                }
            }
            for (Bundle b : state.bundles) {
                Dictionary d = b.getHeaders();
                String fragmentHostHeader = (String)d.get("Fragment-Host");
                if (fragmentHostHeader != null && fragmentHostHeader.trim().length() != 0 || !state.installed.contains(b) && (b.getState() == 8 || b.getState() == 32 || !this.getStartLevel().isBundlePersistentlyStarted(b))) continue;
                try {
                    b.start();
                }
                catch (BundleException be) {
                    Object[] msgdata = new String[]{b.getLocation(), this.getFeaturesContainingBundleList(b), be.getMessage()};
                    String msg = MessageFormatter.arrayFormat((String)"Could not start bundle {} in feature(s) {}: {}", (Object[])msgdata);
                    throw new Exception(msg, be);
                }
            }
            if (!options.contains((Object)FeaturesService.Option.NoCleanIfFailure)) {
                failure.installed.removeAll(state.bundles);
                for (Bundle b : failure.installed) {
                    try {
                        b.uninstall();
                    }
                    catch (Exception e2) {}
                }
            }
        }
        catch (Exception e) {
            if (!options.contains((Object)FeaturesService.Option.NoCleanIfFailure)) {
                for (Bundle b : state.installed) {
                    try {
                        b.uninstall();
                    }
                    catch (Exception e2) {}
                }
                for (Bundle b : failure.installed) {
                    try {
                        b.uninstall();
                    }
                    catch (Exception e2) {}
                }
            } else {
                for (Bundle b : state.installed) {
                    try {
                        b.start();
                    }
                    catch (Exception e2) {}
                }
            }
            throw e;
        }
        for (Feature feature : features) {
            this.callListeners(new FeatureEvent(feature, FeatureEvent.EventType.FeatureInstalled, false));
        }
        for (Map.Entry entry : state.features.entrySet()) {
            this.installed.put((Feature)entry.getKey(), (Set<Long>)entry.getValue());
        }
        this.saveState();
    }

    protected void doInstallFeature(InstallationState state, Feature feature) throws Exception {
        for (Feature dependency : feature.getDependencies()) {
            Feature f = this.getFeature(dependency.getName(), dependency.getVersion());
            if (f == null) {
                throw new Exception("No feature named '" + dependency.getName() + "' with version '" + dependency.getVersion() + "' available");
            }
            this.doInstallFeature(state, f);
        }
        for (String config : feature.getConfigurations().keySet()) {
            Hashtable<String, String> props = new Hashtable<String, String>(feature.getConfigurations().get(config));
            String[] pid = this.parsePid(config);
            Configuration cfg = this.findExistingConfiguration(this.configAdmin, pid[0], pid[1]);
            if (cfg != null) continue;
            cfg = this.createConfiguration(this.configAdmin, pid[0], pid[1]);
            String key = pid[1] == null ? pid[0] : pid[0] + "-" + pid[1];
            ((Dictionary)props).put(CONFIG_KEY, key);
            if (cfg.getBundleLocation() != null) {
                cfg.setBundleLocation(null);
            }
            cfg.update(props);
        }
        HashSet<Long> bundles = new HashSet<Long>();
        for (String bundleLocation : feature.getBundles()) {
            Bundle b = this.installBundleIfNeeded(state, bundleLocation);
            bundles.add(b.getBundleId());
        }
        state.features.put(feature, bundles);
    }

    protected Set<Bundle> findBundlesToRefresh(InstallationState state) {
        List importsList;
        HashSet<Bundle> bundles = new HashSet<Bundle>(state.bundles);
        bundles.removeAll(state.installed);
        if (bundles.isEmpty()) {
            return bundles;
        }
        HashMap<Bundle, List> imports = new HashMap<Bundle, List>();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle b = (Bundle)it.next();
            String importsStr = (String)b.getHeaders().get("Import-Package");
            if (importsStr == null) {
                it.remove();
                continue;
            }
            importsList = HeaderParser.parseHeader(importsStr);
            Iterator<HeaderParser.PathElement> itp = importsList.iterator();
            while (itp.hasNext()) {
                HeaderParser.PathElement p = itp.next();
                String resolution = p.getDirective("resolution");
                if ("optional".equals(resolution)) continue;
                itp.remove();
            }
            if (importsList.isEmpty()) {
                it.remove();
                continue;
            }
            imports.put(b, importsList);
        }
        if (bundles.isEmpty()) {
            return bundles;
        }
        ArrayList<HeaderParser.PathElement> exports = new ArrayList<HeaderParser.PathElement>();
        for (Bundle b : state.installed) {
            String exportsStr = (String)b.getHeaders().get("Export-Package");
            if (exportsStr == null) continue;
            List<HeaderParser.PathElement> exportsList = HeaderParser.parseHeader(exportsStr);
            exports.addAll(exportsList);
        }
        Iterator it2 = bundles.iterator();
        while (it2.hasNext()) {
            Bundle b;
            b = (Bundle)it2.next();
            importsList = (List)imports.get(b);
            Iterator itpi = importsList.iterator();
            while (itpi.hasNext()) {
                HeaderParser.PathElement pi = (HeaderParser.PathElement)itpi.next();
                boolean matching = false;
                for (HeaderParser.PathElement pe : exports) {
                    Version exported;
                    if (!pi.getName().equals(pe.getName())) continue;
                    String evStr = pe.getAttribute("version");
                    String ivStr = pi.getAttribute("version");
                    VersionRange imported = ivStr != null ? VersionRange.parse((String)ivStr) : VersionRange.infiniteRange;
                    if (!imported.isInRange(exported = evStr != null ? Version.parseVersion((String)evStr) : Version.emptyVersion)) continue;
                    matching = true;
                    break;
                }
                if (matching) continue;
                itpi.remove();
            }
            if (importsList.isEmpty()) {
                it2.remove();
                continue;
            }
            LOGGER.debug("Refeshing bundle {} ({}) to solve the following optional imports", (Object)b.getSymbolicName(), (Object)b.getBundleId());
            for (HeaderParser.PathElement p : importsList) {
                LOGGER.debug("    {}", (Object)p);
            }
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle installBundleIfNeeded(InstallationState state, String bundleLocation) throws IOException, BundleException {
        BufferedInputStream is;
        LOGGER.debug("Checking " + bundleLocation);
        try {
            is = new BufferedInputStream(new URL(bundleLocation).openStream());
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        try {
            ((InputStream)is).mark(262144);
            JarInputStream jar = new JarInputStream(is);
            Manifest m = jar.getManifest();
            String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
            String vStr = m.getMainAttributes().getValue("Bundle-Version");
            Version v = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
            for (Bundle b : this.bundleContext.getBundles()) {
                Version bv;
                if (b.getSymbolicName() == null || !b.getSymbolicName().equals(sn)) continue;
                vStr = (String)b.getHeaders().get("Bundle-Version");
                Version version = bv = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
                if (!v.equals((Object)bv)) continue;
                LOGGER.debug("  found installed bundle: " + b);
                state.bundles.add(b);
                Bundle bundle = b;
                return bundle;
            }
            try {
                ((InputStream)is).reset();
            }
            catch (IOException e) {
                ((InputStream)is).close();
                is = new BufferedInputStream(new URL(bundleLocation).openStream());
            }
            LOGGER.debug("Installing bundle " + bundleLocation);
            Bundle b = this.getBundleContext().installBundle(bundleLocation, (InputStream)is);
            state.bundles.add(b);
            state.installed.add(b);
            Bundle bundle = b;
            return bundle;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    @Override
    public void uninstallFeature(String name) throws Exception {
        ArrayList<String> versions = new ArrayList<String>();
        for (Feature f : this.installed.keySet()) {
            if (!name.equals(f.getName())) continue;
            versions.add(f.getVersion());
        }
        if (versions.size() == 0) {
            throw new Exception("Feature named '" + name + "' is not installed");
        }
        if (versions.size() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Feature named '").append(name).append("' has multiple versions installed (");
            for (int i = 0; i < versions.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((String)versions.get(i));
            }
            sb.append("). Please specify the version to uninstall.");
            throw new Exception(sb.toString());
        }
        this.uninstallFeature(name, (String)versions.get(0));
    }

    @Override
    public void uninstallFeature(String name, String version) throws Exception {
        Feature feature = this.getFeature(name, version);
        if (feature == null || !this.installed.containsKey(feature)) {
            throw new Exception("Feature named '" + name + "' with version '" + version + "' is not installed");
        }
        Set<Long> bundles = this.installed.remove(feature);
        for (Set<Long> b : this.installed.values()) {
            bundles.removeAll(b);
        }
        Iterator<Object> i$ = bundles.iterator();
        while (i$.hasNext()) {
            long bundleId = (Long)i$.next();
            Bundle b = this.getBundleContext().getBundle(bundleId);
            if (b == null) continue;
            b.uninstall();
        }
        if (this.getPackageAdmin() != null) {
            this.getPackageAdmin().refreshPackages(null);
        }
        this.callListeners(new FeatureEvent(feature, FeatureEvent.EventType.FeatureInstalled, false));
        this.saveState();
    }

    @Override
    public Feature[] listFeatures() throws Exception {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Map<String, Feature> featureWithDifferentVersion : this.getFeatures().values()) {
            for (Feature f : featureWithDifferentVersion.values()) {
                features.add(f);
            }
        }
        return features.toArray(new Feature[features.size()]);
    }

    @Override
    public Feature[] listInstalledFeatures() {
        Set<Feature> result = this.installed.keySet();
        return result.toArray(new Feature[result.size()]);
    }

    @Override
    public boolean isInstalled(Feature f) {
        return this.installed.containsKey(f);
    }

    protected Feature getFeature(String name, String version) throws Exception {
        Map<String, Feature> versions;
        if (version != null) {
            version = version.trim();
        }
        if ((versions = this.getFeatures().get(name)) == null || versions.isEmpty()) {
            return null;
        }
        Feature feature = versions.get(version);
        if (feature == null && FeatureImpl.DEFAULT_VERSION.equals(version)) {
            Version latest = new Version(FeaturesServiceImpl.cleanupVersion(version));
            for (String available : versions.keySet()) {
                Version availableVersion = new Version(FeaturesServiceImpl.cleanupVersion(available));
                if (availableVersion.compareTo((Object)latest) <= 0) continue;
                feature = versions.get(available);
                latest = availableVersion;
            }
        }
        return feature;
    }

    protected Map<String, Map<String, Feature>> getFeatures() throws Exception {
        if (this.features == null) {
            boolean newRepo;
            HashMap<String, Map<String, Feature>> map = new HashMap<String, Map<String, Feature>>();
            do {
                newRepo = false;
                for (Repository repo : this.listRepositories()) {
                    for (URI uri : repo.getRepositories()) {
                        if (this.repositories.containsKey(uri)) continue;
                        this.internalAddRepository(uri);
                        newRepo = true;
                    }
                }
            } while (newRepo);
            for (RepositoryImpl repo : this.repositories.values()) {
                for (Feature f : repo.getFeatures()) {
                    if (map.get(f.getName()) == null) {
                        HashMap<String, Feature> versionMap = new HashMap<String, Feature>();
                        versionMap.put(f.getVersion(), f);
                        map.put(f.getName(), versionMap);
                        continue;
                    }
                    ((Map)map.get(f.getName())).put(f.getVersion(), f);
                }
            }
            this.features = map;
        }
        return this.features;
    }

    public void start() throws Exception {
        if (!this.loadState()) {
            if (this.uris != null) {
                for (URI uri : this.uris) {
                    try {
                        this.internalAddRepository(uri);
                    }
                    catch (Exception e) {
                        LOGGER.warn(String.format("Unable to add features repository %s at startup", uri), (Throwable)e);
                    }
                }
            }
            this.saveState();
        }
        if (this.boot != null && !this.bootFeaturesInstalled) {
            new Thread(){

                public void run() {
                    String[] list = FeaturesServiceImpl.this.boot.split(",");
                    LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
                    for (String f : list) {
                        if (f.length() <= 0) continue;
                        try {
                            Feature feature = FeaturesServiceImpl.this.getFeature(f, FeatureImpl.DEFAULT_VERSION);
                            if (feature != null) {
                                features.add(feature);
                                continue;
                            }
                            LOGGER.error("Error installing boot feature " + f + ": feature not found");
                        }
                        catch (Exception e) {
                            LOGGER.error("Error installing boot feature " + f, (Throwable)e);
                        }
                    }
                    try {
                        FeaturesServiceImpl.this.installFeatures(features, EnumSet.of(FeaturesService.Option.NoCleanIfFailure, FeaturesService.Option.ContinueBatchOnFailure));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error installing boot features", (Throwable)e);
                    }
                    FeaturesServiceImpl.this.bootFeaturesInstalled = true;
                    FeaturesServiceImpl.this.saveState();
                }
            }.start();
        }
    }

    public void stop() throws Exception {
        this.uris = new HashSet<URI>(this.repositories.keySet());
        while (!this.repositories.isEmpty()) {
            this.internalRemoveRepository(this.repositories.keySet().iterator().next());
        }
    }

    protected String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    protected Configuration createConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        if (factoryPid != null) {
            return configurationAdmin.createFactoryConfiguration(pid, null);
        }
        return configurationAdmin.getConfiguration(pid, null);
    }

    protected Configuration findExistingConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        String key = factoryPid == null ? pid : pid + "-" + factoryPid;
        String filter = factoryPid == null ? "(service.pid=" + pid + ")" : "(service.factoryPid=" + factoryPid + ")";
        Configuration[] configurations = configurationAdmin.listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    protected void saveState() {
        try {
            Preferences prefs = this.preferences.getUserPreferences("FeaturesServiceState");
            this.saveSet(prefs.node("repositories"), this.repositories.keySet());
            this.saveMap(prefs.node("features"), this.installed);
            prefs.putBoolean("bootFeaturesInstalled", this.bootFeaturesInstalled);
            prefs.flush();
        }
        catch (Exception e) {
            LOGGER.error("Error persisting FeaturesService state", (Throwable)e);
        }
    }

    protected boolean loadState() {
        try {
            Preferences prefs = this.preferences.getUserPreferences("FeaturesServiceState");
            if (prefs.nodeExists("repositories")) {
                Set<URI> repositories = this.loadSet(prefs.node("repositories"));
                for (URI repo : repositories) {
                    this.internalAddRepository(repo);
                }
                this.installed = this.loadMap(prefs.node("features"));
                for (Feature f : this.installed.keySet()) {
                    this.callListeners(new FeatureEvent(f, FeatureEvent.EventType.FeatureInstalled, true));
                }
                this.bootFeaturesInstalled = prefs.getBoolean("bootFeaturesInstalled", false);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading FeaturesService state", (Throwable)e);
        }
        return false;
    }

    protected void saveSet(Preferences node, Set<URI> set) throws BackingStoreException {
        ArrayList<URI> l = new ArrayList<URI>(set);
        node.clear();
        node.putInt("count", l.size());
        for (int i = 0; i < l.size(); ++i) {
            node.put("item." + i, ((URI)l.get(i)).toString());
        }
    }

    protected Set<URI> loadSet(Preferences node) {
        HashSet<URI> l = new HashSet<URI>();
        int count = node.getInt("count", 0);
        for (int i = 0; i < count; ++i) {
            l.add(URI.create(node.get("item." + i, null)));
        }
        return l;
    }

    protected void saveMap(Preferences node, Map<Feature, Set<Long>> map) throws BackingStoreException {
        node.clear();
        for (Map.Entry<Feature, Set<Long>> entry : map.entrySet()) {
            Feature key = entry.getKey();
            String val = this.createValue(entry.getValue());
            node.put(key.toString(), val);
        }
    }

    protected Map<Feature, Set<Long>> loadMap(Preferences node) throws BackingStoreException {
        HashMap<Feature, Set<Long>> map = new HashMap<Feature, Set<Long>>();
        for (String key : node.keys()) {
            String val = node.get(key, null);
            Set<Long> set = this.readValue(val);
            map.put(FeatureImpl.valueOf(key), set);
        }
        return map;
    }

    protected String createValue(Set<Long> set) {
        StringBuilder sb = new StringBuilder();
        for (long i : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(i);
        }
        return sb.toString();
    }

    protected Set<Long> readValue(String val) {
        HashSet<Long> set = new HashSet<Long>();
        if (val != null && val.length() != 0) {
            for (String str : val.split(",")) {
                set.add(Long.parseLong(str));
            }
        }
        return set;
    }

    protected void callListeners(FeatureEvent event) {
        for (FeaturesListener listener : this.listeners) {
            listener.featureEvent(event);
        }
    }

    protected void callListeners(RepositoryEvent event) {
        for (FeaturesListener listener : this.listeners) {
            listener.repositoryEvent(event);
        }
    }

    public static String cleanupVersion(String version) {
        Matcher m = fuzzyVersion.matcher(version);
        if (m.matches()) {
            StringBuffer result = new StringBuffer();
            String d1 = m.group(1);
            String d2 = m.group(3);
            String d3 = m.group(5);
            String qualifier = m.group(7);
            if (d1 != null) {
                result.append(d1);
                if (d2 != null) {
                    result.append(".");
                    result.append(d2);
                    if (d3 != null) {
                        result.append(".");
                        result.append(d3);
                        if (qualifier != null) {
                            result.append(".");
                            FeaturesServiceImpl.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        FeaturesServiceImpl.cleanupModifier(result, qualifier);
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    FeaturesServiceImpl.cleanupModifier(result, qualifier);
                }
                return result.toString();
            }
        }
        return version;
    }

    static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = fuzzyModifier.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(2);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }

    public Set<Feature> getFeaturesContainingBundle(Bundle bundle) throws Exception {
        HashSet<Feature> features = new HashSet<Feature>();
        for (Map<String, Feature> featureMap : this.getFeatures().values()) {
            for (Feature f : featureMap.values()) {
                if (!f.getBundles().contains(bundle.getLocation())) continue;
                features.add(f);
            }
        }
        return features;
    }

    private String getFeaturesContainingBundleList(Bundle bundle) throws Exception {
        Set<Feature> features = this.getFeaturesContainingBundle(bundle);
        StringBuilder buffer = new StringBuilder();
        Iterator<Feature> iter = features.iterator();
        while (iter.hasNext()) {
            Feature feature = iter.next();
            buffer.append(feature.getId());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    protected static class InstallationState {
        final Set<Bundle> installed = new HashSet<Bundle>();
        final List<Bundle> bundles = new ArrayList<Bundle>();
        final Map<Feature, Set<Long>> features = new HashMap<Feature, Set<Long>>();

        protected InstallationState() {
        }
    }
}

