/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.javaxwrappers;

import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.http.jakartawrappers.ServletResponseWrapper;
import org.apache.felix.http.javaxwrappers.AsyncContextWrapper;
import org.apache.felix.http.javaxwrappers.HttpServletMappingWrapper;
import org.apache.felix.http.javaxwrappers.HttpServletRequestWrapper;
import org.apache.felix.http.javaxwrappers.RequestDispatcherWrapper;
import org.apache.felix.http.javaxwrappers.ServletContextWrapper;
import org.apache.felix.http.javaxwrappers.ServletInputStreamWrapper;
import org.jetbrains.annotations.NotNull;

public class ServletRequestWrapper
implements ServletRequest {
    private static final String JAVAX_ERROR_METHOD = "jakarta.servlet.error.method".replace("jakarta", "javax");
    private static final String JAVAX_ERROR_QUERY_STRING = "jakarta.servlet.error.query_string".replace("jakarta", "javax");
    private final jakarta.servlet.ServletRequest request;

    public static ServletRequest getWrapper(jakarta.servlet.ServletRequest r) {
        if (r instanceof org.apache.felix.http.jakartawrappers.ServletRequestWrapper) {
            return ((org.apache.felix.http.jakartawrappers.ServletRequestWrapper)r).getRequest();
        }
        if (r instanceof HttpServletRequest) {
            return new HttpServletRequestWrapper((HttpServletRequest)r);
        }
        return new ServletRequestWrapper(r);
    }

    public ServletRequestWrapper(@NotNull jakarta.servlet.ServletRequest r) {
        this.request = r;
    }

    public jakarta.servlet.ServletRequest getRequest() {
        return this.request;
    }

    private Object wrapHttpServletMapping(Object value) {
        if (value instanceof org.apache.felix.http.jakartawrappers.HttpServletMappingWrapper) {
            return ((org.apache.felix.http.jakartawrappers.HttpServletMappingWrapper)value).getMapping();
        }
        if (value instanceof HttpServletMapping) {
            return new HttpServletMappingWrapper((HttpServletMapping)value);
        }
        return value;
    }

    public static String getTranslatedAttributeName(String name) {
        if ("javax.servlet.forward.context_path".equals(name)) {
            return "jakarta.servlet.forward.context_path";
        }
        if ("javax.servlet.forward.mapping".equals(name)) {
            return "jakarta.servlet.forward.mapping";
        }
        if ("javax.servlet.forward.path_info".equals(name)) {
            return "jakarta.servlet.forward.path_info";
        }
        if ("javax.servlet.forward.query_string".equals(name)) {
            return "jakarta.servlet.forward.query_string";
        }
        if ("javax.servlet.forward.request_uri".equals(name)) {
            return "jakarta.servlet.forward.request_uri";
        }
        if ("javax.servlet.forward.servlet_path".equals(name)) {
            return "jakarta.servlet.forward.servlet_path";
        }
        if ("javax.servlet.include.context_path".equals(name)) {
            return "jakarta.servlet.include.context_path";
        }
        if ("javax.servlet.include.mapping".equals(name)) {
            return "jakarta.servlet.include.mapping";
        }
        if ("javax.servlet.include.path_info".equals(name)) {
            return "jakarta.servlet.include.path_info";
        }
        if ("javax.servlet.include.query_string".equals(name)) {
            return "jakarta.servlet.include.query_string";
        }
        if ("javax.servlet.include.request_uri".equals(name)) {
            return "jakarta.servlet.include.request_uri";
        }
        if ("javax.servlet.include.servlet_path".equals(name)) {
            return "jakarta.servlet.include.servlet_path";
        }
        if ("javax.servlet.error.exception".equals(name)) {
            return "jakarta.servlet.error.exception";
        }
        if ("javax.servlet.error.exception_type".equals(name)) {
            return "jakarta.servlet.error.exception_type";
        }
        if ("javax.servlet.error.message".equals(name)) {
            return "jakarta.servlet.error.message";
        }
        if ("javax.servlet.error.request_uri".equals(name)) {
            return "jakarta.servlet.error.request_uri";
        }
        if ("javax.servlet.error.servlet_name".equals(name)) {
            return "jakarta.servlet.error.servlet_name";
        }
        if ("javax.servlet.error.status_code".equals(name)) {
            return "jakarta.servlet.error.status_code";
        }
        if (JAVAX_ERROR_METHOD.equals(name)) {
            return "jakarta.servlet.error.method";
        }
        if (JAVAX_ERROR_QUERY_STRING.equals(name)) {
            return "jakarta.servlet.error.query_string";
        }
        if ("javax.servlet.async.context_path".equals(name)) {
            return "jakarta.servlet.async.context_path";
        }
        if ("javax.servlet.async.mapping".equals(name)) {
            return "jakarta.servlet.async.mapping";
        }
        if ("javax.servlet.async.path_info".equals(name)) {
            return "jakarta.servlet.async.path_info";
        }
        if ("javax.servlet.async.query_string".equals(name)) {
            return "jakarta.servlet.async.query_string";
        }
        if ("javax.servlet.async.request_uri".equals(name)) {
            return "jakarta.servlet.async.request_uri";
        }
        if ("javax.servlet.async.servlet_path".equals(name)) {
            return "jakarta.servlet.async.servlet_path";
        }
        return null;
    }

    public Object getAttribute(String name) {
        String translatedName = ServletRequestWrapper.getTranslatedAttributeName(name);
        if (translatedName != null) {
            Object value = this.request.getAttribute(translatedName);
            if ("javax.servlet.forward.mapping".equals(name)) {
                return this.wrapHttpServletMapping(value);
            }
            if ("javax.servlet.include.mapping".equals(name)) {
                return this.wrapHttpServletMapping(value);
            }
            if ("javax.servlet.async.mapping".equals(name)) {
                return this.wrapHttpServletMapping(value);
            }
            return value;
        }
        return this.request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        ArrayList<String> names = Collections.list(this.request.getAttributeNames());
        ArrayList<String> translatedNames = new ArrayList<String>();
        for (String name : names) {
            String translatedName = org.apache.felix.http.jakartawrappers.ServletRequestWrapper.getTranslatedAttributeName(name);
            if (translatedName != null) {
                translatedNames.add(translatedName);
                continue;
            }
            translatedNames.add(name);
        }
        return Collections.enumeration(translatedNames);
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public long getContentLengthLong() {
        return this.request.getContentLengthLong();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamWrapper(this.request.getInputStream());
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        String translatedName = ServletRequestWrapper.getTranslatedAttributeName(name);
        if (translatedName != null) {
            this.request.removeAttribute(name);
            this.request.setAttribute(translatedName, o);
        } else {
            this.request.setAttribute(name, o);
        }
    }

    public void removeAttribute(String name) {
        String translatedName = ServletRequestWrapper.getTranslatedAttributeName(name);
        this.request.removeAttribute(name);
        if (translatedName != null) {
            this.request.removeAttribute(translatedName);
        }
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        jakarta.servlet.RequestDispatcher dispatcher = this.request.getRequestDispatcher(path);
        if (dispatcher != null) {
            return new RequestDispatcherWrapper(dispatcher);
        }
        return null;
    }

    public String getRealPath(String path) {
        return this.request.getServletContext().getRealPath(path);
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public ServletContext getServletContext() {
        return new ServletContextWrapper(this.request.getServletContext());
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return new AsyncContextWrapper(this.request.startAsync());
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return new AsyncContextWrapper(this.request.startAsync(org.apache.felix.http.jakartawrappers.ServletRequestWrapper.getWrapper(servletRequest), ServletResponseWrapper.getWrapper(servletResponse)));
    }

    public boolean isAsyncStarted() {
        return this.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.request.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return new AsyncContextWrapper(this.request.getAsyncContext());
    }

    public DispatcherType getDispatcherType() {
        switch (this.request.getDispatcherType()) {
            case ASYNC: {
                return DispatcherType.ASYNC;
            }
            case ERROR: {
                return DispatcherType.ERROR;
            }
            case FORWARD: {
                return DispatcherType.FORWARD;
            }
            case INCLUDE: {
                return DispatcherType.INCLUDE;
            }
            case REQUEST: {
                return DispatcherType.REQUEST;
            }
        }
        return null;
    }
}

