/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

import java.math.RoundingMode;

public class NumberUsage {
    public static final int use_Number = 0;
    public static final int use_decimal = 1;
    public static final int use_double = 2;
    public static final int use_int = 3;
    public static final int use_uint = 4;
    public static final int round_CEILING = 0;
    public static final int round_UP = 1;
    public static final int round_HALF_UP = 2;
    public static final int round_HALF_EVEN = 3;
    public static final int round_HALF_DOWN = 4;
    public static final int round_DOWN = 5;
    public static final int round_FLOOR = 6;
    public static final int defaultparam = new NumberUsage().encode();
    public static final String[] roundingModeName = new String[]{"CEILING", "UP", "HALF_UP", "HALF_EVEN", "HALF_DOWN", "DOWN", "FLOOR"};
    private int usage;
    private int rounding;
    private int precision;
    private int floating_usage;

    public RoundingMode fromDecNumberRounding(int ndx) {
        if (ndx == 0) {
            return RoundingMode.CEILING;
        }
        if (ndx == 1) {
            return RoundingMode.UP;
        }
        if (ndx == 2) {
            return RoundingMode.HALF_UP;
        }
        if (ndx == 3) {
            return RoundingMode.HALF_EVEN;
        }
        if (ndx == 4) {
            return RoundingMode.HALF_DOWN;
        }
        if (ndx == 5) {
            return RoundingMode.DOWN;
        }
        if (ndx == 6) {
            return RoundingMode.FLOOR;
        }
        return null;
    }

    public NumberUsage() {
        this.usage = 0;
        this.rounding = 3;
        this.precision = 34;
        this.floating_usage = 0;
    }

    public NumberUsage(NumberUsage nu) {
        this.usage = nu.usage;
        this.rounding = nu.rounding;
        this.precision = nu.precision;
        this.floating_usage = nu.floating_usage;
    }

    public void set_usage(int u) {
        assert (u <= 4);
        this.usage = u;
        if (u <= 2) {
            this.floating_usage = u;
        }
    }

    public void set_rounding(int r) {
        assert (r <= 6);
        this.rounding = r;
    }

    public void set_precision(int p) {
        assert (p <= 34);
        this.precision = p;
    }

    public int get_usage() {
        return this.usage;
    }

    public int get_floating_usage() {
        return this.floating_usage;
    }

    public int get_rounding() {
        return this.rounding;
    }

    public RoundingMode get_java_roundingMode() {
        return this.fromDecNumberRounding(this.rounding);
    }

    public int get_precision() {
        return this.precision;
    }

    public boolean is_default() {
        return this.usage == 0 && this.rounding == 3 && this.precision == 34;
    }

    public int encode() {
        int ret = this.usage;
        if (this.usage <= 1) {
            ret |= this.rounding << 3;
            if (this.precision < 34) {
                ret |= this.precision << 6;
            }
        }
        return ret;
    }
}

