////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

package
{

/**
 *  @private
 *  In some projects, this class is used to link additional classes
 *  into the SWC beyond those that are found by dependency analysis
 *  starting from the classes specified in manifest.xml.
 *  This project has no manifest file (because there are no MXML tags
 *  corresponding to any classes in it) so all the classes linked into
 *  the SWC are found by a dependency analysis starting from the classes
 *  listed here.
 */
internal class CobaltClasses
{

import cobalt.skins.ApplicationSkin; ApplicationSkin;
import cobalt.skins.BorderSkin; BorderSkin;
import cobalt.skins.ButtonBarFirstButtonSkin; ButtonBarFirstButtonSkin;
import cobalt.skins.ButtonBarLastButtonSkin; ButtonBarLastButtonSkin;
import cobalt.skins.ButtonBarMiddleButtonSkin; ButtonBarMiddleButtonSkin;
import cobalt.skins.ButtonBarSkin; ButtonBarSkin;
import cobalt.skins.ButtonSkin; ButtonSkin;
import cobalt.skins.CheckBoxSkin; CheckBoxSkin;
import cobalt.skins.ComboBoxButtonSkin; ComboBoxButtonSkin;
import cobalt.skins.ComboBoxSkin; ComboBoxSkin;
import cobalt.skins.ComboBoxTextInputSkin; ComboBoxTextInputSkin;
import cobalt.skins.DefaultButtonSkin; DefaultButtonSkin;
import cobalt.skins.DefaultComplexItemRenderer; DefaultComplexItemRenderer;
import cobalt.skins.DefaultItemRenderer; DefaultItemRenderer;
import cobalt.skins.DropDownListButtonSkin; DropDownListButtonSkin;
import cobalt.skins.DropDownListSkin; DropDownListSkin;
import cobalt.skins.ErrorSkin; ErrorSkin;
import cobalt.skins.FocusSkin; FocusSkin;
import cobalt.skins.HScrollBarSkin; HScrollBarSkin;
import cobalt.skins.HScrollBarThumbSkin; HScrollBarThumbSkin;
import cobalt.skins.HScrollBarTrackSkin; HScrollBarTrackSkin;
import cobalt.skins.HSliderSkin; HSliderSkin;
import cobalt.skins.HSliderThumbSkin; HSliderThumbSkin;
import cobalt.skins.HSliderTrackSkin; HSliderTrackSkin;
import cobalt.skins.HighlightBitmapCaptureSkin; HighlightBitmapCaptureSkin;
import cobalt.skins.ListSkin; ListSkin;
import cobalt.skins.NumericStepperSkin; NumericStepperSkin;
import cobalt.skins.NumericStepperTextInputSkin; NumericStepperTextInputSkin;
import cobalt.skins.PanelBorderSkin; PanelBorderSkin;
import cobalt.skins.PanelSkin; PanelSkin;
import cobalt.skins.RadioButtonSkin; RadioButtonSkin;
import cobalt.skins.ScrollBarDownButtonSkin; ScrollBarDownButtonSkin;
import cobalt.skins.ScrollBarLeftButtonSkin; ScrollBarLeftButtonSkin;
import cobalt.skins.ScrollBarRightButtonSkin; ScrollBarRightButtonSkin;
import cobalt.skins.ScrollBarUpButtonSkin; ScrollBarUpButtonSkin;
import cobalt.skins.ScrollerSkin; ScrollerSkin;
import cobalt.skins.SkinnableContainerSkin; SkinnableContainerSkin;
import cobalt.skins.SkinnableDataContainerSkin; SkinnableDataContainerSkin;
import cobalt.skins.SpinnerDecrementButtonSkin; SpinnerDecrementButtonSkin;
import cobalt.skins.SpinnerIncrementButtonSkin; SpinnerIncrementButtonSkin;
import cobalt.skins.SpinnerSkin; SpinnerSkin;
import cobalt.skins.TabBarButtonSkin; TabBarButtonSkin;
import cobalt.skins.TabBarSkin; TabBarSkin;
import cobalt.skins.TextAreaSkin; TextAreaSkin;
import cobalt.skins.TextInputSkin; TextInputSkin;
import cobalt.skins.TitleWindowCloseButtonSkin; TitleWindowCloseButtonSkin;
import cobalt.skins.TitleWindowSkin; TitleWindowSkin;
import cobalt.skins.ToggleButtonSkin; ToggleButtonSkin;
import cobalt.skins.VScrollBarSkin; VScrollBarSkin;
import cobalt.skins.VScrollBarThumbSkin; VScrollBarThumbSkin;
import cobalt.skins.VScrollBarTrackSkin; VScrollBarTrackSkin;
import cobalt.skins.VSliderSkin; VSliderSkin;
import cobalt.skins.VSliderThumbSkin; VSliderThumbSkin;
import cobalt.skins.VSliderTrackSkin; VSliderTrackSkin;
import cobalt.skins.VideoPlayerSkin; VideoPlayerSkin;

}
}