/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public class IterableSubject<S extends IterableSubject<S, T, C>, T, C extends Iterable<T>>
extends Subject<S, C> {
    private static final Ordered IN_ORDER = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    static <T, C extends Iterable<T>> IterableSubject<? extends IterableSubject<?, T, C>, T, C> create(FailureStrategy failureStrategy, Iterable<T> list) {
        return new IterableSubject(failureStrategy, list);
    }

    IterableSubject(FailureStrategy failureStrategy, C list) {
        super(failureStrategy, list);
    }

    public void isEmpty() {
        if (!Iterables.isEmpty((Iterable)((Iterable)this.getSubject()))) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (Iterables.isEmpty((Iterable)((Iterable)this.getSubject()))) {
            this.fail("is not empty");
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (Object[])new Object[]{expectedSize});
        int actualSize = Iterables.size((Iterable)((Iterable)this.getSubject()));
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void iteratesAs(Iterable<?> expectedItems) {
        Iterator actualItems = ((Iterable)this.getSubject()).iterator();
        for (Object expected : expectedItems) {
            if (!actualItems.hasNext()) {
                this.fail("iterates through", (Object)expectedItems);
                continue;
            }
            Object actual = actualItems.next();
            if (actual == expected || actual != null && actual.equals(expected)) continue;
            this.fail("iterates through", (Object)expectedItems);
        }
        if (actualItems.hasNext()) {
            this.fail("iterates through", (Object)expectedItems);
        }
    }

    @Deprecated
    public void iteratesOverSequence(Object ... expectedItems) {
        this.iteratesAs(expectedItems);
    }

    public void iteratesAs(Object ... expectedItems) {
        this.iteratesAs(Arrays.asList(expectedItems));
    }

    public void contains(@Nullable Object element) {
        if (!Iterables.contains((Iterable)((Iterable)this.getSubject()), (Object)element)) {
            this.failWithRawMessage("%s should have contained <%s>", this.getDisplaySubject(), element);
        }
    }

    public void doesNotContain(@Nullable Object element) {
        if (Iterables.contains((Iterable)((Iterable)this.getSubject()), (Object)element)) {
            this.failWithRawMessage("%s should not have contained <%s>", this.getDisplaySubject(), element);
        }
    }

    public void containsNoDuplicates() {
        ArrayList duplicates = Lists.newArrayList();
        for (Multiset.Entry entry : LinkedHashMultiset.create((Iterable)((Iterable)this.getSubject())).entrySet()) {
            if (entry.getCount() <= 1) continue;
            duplicates.add(entry);
        }
        if (!duplicates.isEmpty()) {
            this.failWithRawMessage("%s has the following duplicates: <%s>", this.getDisplaySubject(), duplicates);
        }
    }

    public void containsAnyOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.contains("contains any of", SubjectUtils.accumulate(first, second, rest));
    }

    public void containsAnyIn(Iterable<?> expected) {
        this.contains("contains any element in", expected);
    }

    private void contains(String failVerb, Iterable<?> expected) {
        for (Object item : expected) {
            if (!Iterables.contains((Iterable)((Iterable)this.getSubject()), item)) continue;
            return;
        }
        this.fail(failVerb, (Object)expected);
    }

    public Ordered containsAllOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        return this.containsAll("contains all of", SubjectUtils.accumulate(first, second, rest));
    }

    public Ordered containsAllIn(Iterable<?> expected) {
        return this.containsAll("contains all elements in", expected);
    }

    private Ordered containsAll(String failVerb, Iterable<?> expected) {
        ArrayList toRemove = Lists.newArrayList(expected);
        boolean inOrder = true;
        for (Object item : (Iterable)this.getSubject()) {
            int index = toRemove.indexOf(item);
            if (index == -1) continue;
            toRemove.remove(index);
            inOrder &= index == 0;
        }
        if (!toRemove.isEmpty()) {
            this.failWithBadResults(failVerb, expected, "is missing", SubjectUtils.countDuplicates(toRemove));
        }
        return inOrder ? IN_ORDER : new NotInOrder("contains all elements in order", expected);
    }

    @Deprecated
    public Ordered containsOnlyElements(@Nullable Object first, @Nullable Object second, Object ... rest) {
        return this.containsExactlyElementsIn(SubjectUtils.accumulate(first, second, rest));
    }

    @Deprecated
    public Ordered containsOnlyElementsIn(Iterable<?> expected) {
        return this.containsExactlyElementsIn(expected);
    }

    public Ordered containsExactly(Object ... varargs) {
        return this.containsExactly("contains exactly", Arrays.asList(varargs));
    }

    public Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.containsExactly("contains exactly", expected);
    }

    private Ordered containsExactly(String failVerb, Iterable<?> required) {
        Iterator actualIter = ((Iterable)this.getSubject()).iterator();
        Iterator<?> requiredIter = required.iterator();
        while (actualIter.hasNext() && requiredIter.hasNext()) {
            Object requiredElement;
            Object actualElement = actualIter.next();
            if (Objects.equal(actualElement, requiredElement = requiredIter.next())) continue;
            ArrayList missing = Lists.newArrayList();
            missing.add(requiredElement);
            Iterators.addAll((Collection)missing, requiredIter);
            ArrayList extra = Lists.newArrayList();
            if (!missing.remove(actualElement)) {
                extra.add(actualElement);
            }
            while (actualIter.hasNext()) {
                Object item = actualIter.next();
                if (missing.remove(item)) continue;
                extra.add(item);
            }
            if (!missing.isEmpty()) {
                this.failWithBadResults(failVerb, required, "is missing", SubjectUtils.countDuplicates(missing));
            }
            if (!extra.isEmpty()) {
                this.failWithBadResults(failVerb, required, "has unexpected items", SubjectUtils.countDuplicates(extra));
            }
            return new NotInOrder("contains only these elements in order", required);
        }
        if (actualIter.hasNext()) {
            this.failWithBadResults(failVerb, required, "has unexpected items", SubjectUtils.countDuplicates(Lists.newArrayList(actualIter)));
        } else if (requiredIter.hasNext()) {
            this.failWithBadResults(failVerb, required, "is missing", SubjectUtils.countDuplicates(Lists.newArrayList(requiredIter)));
        }
        return IN_ORDER;
    }

    public void containsNoneOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.containsNone("contains none of", SubjectUtils.accumulate(first, second, rest));
    }

    public void containsNoneIn(Iterable<?> excluded) {
        this.containsNone("contains no elements in", excluded);
    }

    private void containsNone(String failVerb, Iterable<?> excluded) {
        ArrayList present = new ArrayList();
        for (Object item : Sets.newHashSet(excluded)) {
            if (!Iterables.contains((Iterable)((Iterable)this.getSubject()), item)) continue;
            present.add(item);
        }
        if (!present.isEmpty()) {
            this.failWithBadResults(failVerb, excluded, "contains", present);
        }
    }

    private class NotInOrder
    implements Ordered {
        private final String check;
        private final Iterable<?> required;

        NotInOrder(String check, Iterable<?> required) {
            this.check = check;
            this.required = required;
        }

        @Override
        public void inOrder() {
            IterableSubject.this.fail(this.check, (Object)this.required);
        }
    }
}

