/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.constants.IASLanguageConstants;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.definitions.references.IReference;
import org.apache.flex.compiler.definitions.references.ReferenceFactory;
import org.apache.flex.compiler.internal.definitions.DefinitionBase;
import org.apache.flex.compiler.internal.definitions.ParameterDefinition;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.scopes.CatchScope;
import org.apache.flex.compiler.internal.semantics.PostProcessStep;
import org.apache.flex.compiler.internal.tree.as.BaseVariableNode;
import org.apache.flex.compiler.internal.tree.as.CatchNode;
import org.apache.flex.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.IdentifierNode;
import org.apache.flex.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.flex.compiler.internal.tree.as.parts.VariableDecorationPart;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IIdentifierNode;
import org.apache.flex.compiler.tree.as.ILiteralNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.tree.as.IScopedNode;
import org.apache.flex.compiler.tree.metadata.IMetaTagsNode;

public final class ParameterNode
extends BaseVariableNode
implements IParameterNode {
    private boolean isRest = false;

    public ParameterNode(IdentifierNode nameNode) {
        super(nameNode);
    }

    public ParameterNode(IdentifierNode nameNode, ExpressionNodeBase typeNode) {
        super(nameNode, typeNode);
    }

    @Override
    public ASTNodeID getNodeID() {
        if (!this.isRest()) {
            return ASTNodeID.ArgumentID;
        }
        return ASTNodeID.ArgumentRestID;
    }

    @Override
    public IScopedNode getScopeNode() {
        FunctionNode function;
        IASNode ancestor = this.getAncestorOfType(FunctionNode.class);
        if (ancestor != null && ancestor instanceof FunctionNode && (function = (FunctionNode)ancestor).getScopedNode() != null) {
            return function.getScopedNode();
        }
        if (this.getParent() != null) {
            return this.getParent().getContainingScope();
        }
        return null;
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (this.isCatchParameter(scope)) {
            if (set.contains((Object)PostProcessStep.POPULATE_SCOPE) || set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
                ParameterDefinition definition = this.buildDefinition();
                this.setDefinition(definition);
                ((CatchScope)scope).setParameterDefinition(definition);
            }
        } else {
            super.analyze(set, scope, problems);
        }
    }

    @Override
    protected int getInitialChildCount() {
        return 3;
    }

    @Override
    public IMetaTagsNode getMetaTags() {
        return null;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public boolean hasNamespace(String namespace) {
        return false;
    }

    @Override
    public boolean hasModifier(ASModifier modifier) {
        return false;
    }

    @Override
    protected void ensureTypeNode() {
        if (this.typeNode == null && this.isRest()) {
            this.typeNode = new IdentifierNode("Array");
            this.typeNode.span(-1, -1, -1, -1);
            return;
        }
        super.ensureTypeNode();
    }

    @Override
    ParameterDefinition buildDefinition() {
        IReference typeRef;
        String definitionName = this.getName();
        ParameterDefinition definition = new ParameterDefinition(definitionName);
        definition.setNode(this);
        this.fillInNamespaceAndModifiers(definition);
        this.setDefinition(definition);
        IReference iReference = typeRef = this.hasExplicitType() ? this.typeNode.computeTypeReference() : null;
        if (typeRef == null && this.isRest()) {
            typeRef = ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.ARRAY);
        }
        definition.setTypeReference(typeRef);
        if (this.hasDefaultValue()) {
            definition.setHasDefault();
            definition.setInitializer(this.getAssignedValueNode());
        }
        if (this.isRest()) {
            definition.setRest();
        }
        return definition;
    }

    @Override
    public DefinitionBase getDefinition() {
        return super.getDefinition();
    }

    @Override
    protected void setDefinition(IDefinition definition) {
        assert (definition instanceof ParameterDefinition);
        super.setDefinition(definition);
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public IVariableDefinition.VariableClassification getVariableClassification() {
        if (this.getAncestorOfType(CatchNode.class) != null) {
            return IVariableDefinition.VariableClassification.LOCAL;
        }
        return IVariableDefinition.VariableClassification.PARAMETER;
    }

    @Override
    public boolean isRest() {
        return this.isRest;
    }

    @Override
    public boolean hasDefaultValue() {
        return ((VariableDecorationPart)this.getDecorationPart()).getAssignedValue() != null;
    }

    @Override
    public String getDefaultValue() {
        ExpressionNodeBase assignedValueNode = ((VariableDecorationPart)this.getDecorationPart()).getAssignedValue();
        if (assignedValueNode != null) {
            if (assignedValueNode instanceof ILiteralNode) {
                return ((ILiteralNode)((Object)assignedValueNode)).getValue(true);
            }
            if (assignedValueNode instanceof IIdentifierNode) {
                return ((IIdentifierNode)((Object)assignedValueNode)).getName();
            }
            if (assignedValueNode instanceof MemberAccessExpressionNode) {
                return ((MemberAccessExpressionNode)assignedValueNode).getDisplayString();
            }
        }
        return null;
    }

    public void setIsRestParameter(boolean isRest) {
        this.isRest = isRest;
    }

    private boolean isCatchParameter(ASScope scope) {
        return scope instanceof CatchScope && this.getParent() instanceof CatchNode;
    }
}

