/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.ManagedTableFactory;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.connector.AbstractTableStoreFactory;
import org.apache.flink.table.store.connector.FlinkConnectorOptions;
import org.apache.flink.table.store.connector.TableConfigUtils;
import org.apache.flink.table.store.connector.TableStoreDynamicContext;
import org.apache.flink.table.store.file.WriteMode;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.UpdateSchema;
import org.apache.flink.table.store.file.utils.JsonSerdeUtil;
import org.apache.flink.table.store.log.LogStoreTableFactory;
import org.apache.flink.util.Preconditions;

public class TableStoreManagedFactory
extends AbstractTableStoreFactory
implements ManagedTableFactory {
    public Map<String, String> enrichOptions(DynamicTableFactory.Context context) {
        HashMap<String, String> enrichedOptions = new HashMap<String, String>(context.getCatalogTable().getOptions());
        TableConfigUtils.extractConfiguration(context.getConfiguration()).toMap().forEach((k, v) -> {
            if (k.startsWith("table-store.")) {
                enrichedOptions.putIfAbsent(k.substring("table-store.".length()), (String)v);
            }
        });
        String rootPath = (String)enrichedOptions.remove(FlinkConnectorOptions.ROOT_PATH.key());
        Preconditions.checkArgument((rootPath != null ? 1 : 0) != 0, (Object)String.format("Please specify a root path by setting session level configuration as `SET 'table-store.%s' = '...'`.", FlinkConnectorOptions.ROOT_PATH.key()));
        Preconditions.checkArgument((!enrichedOptions.containsKey(CoreOptions.PATH.key()) ? 1 : 0) != 0, (Object)"Managed table can not contain table path. You need to remove path in table options or session config.");
        Path path = new Path(rootPath, FlinkConnectorOptions.relativeTablePath(context.getObjectIdentifier()));
        enrichedOptions.put(CoreOptions.PATH.key(), path.toString());
        Optional<LogStoreTableFactory> logFactory = TableStoreManagedFactory.createOptionalLogStoreFactory(context.getClassLoader(), enrichedOptions);
        logFactory.ifPresent(factory -> factory.enrichOptions((DynamicTableFactory.Context)new TableStoreDynamicContext(context, enrichedOptions)).forEach(enrichedOptions::putIfAbsent));
        return enrichedOptions;
    }

    public void onCreateTable(DynamicTableFactory.Context context, boolean ignoreIfExists) {
        Map options = context.getCatalogTable().getOptions();
        Path path = CoreOptions.path(options);
        try {
            if (path.getFileSystem().exists(path) && !ignoreIfExists) {
                throw new TableException(String.format("Failed to create file store path. Reason: directory %s exists for table %s. Suggestion: please try `DESCRIBE TABLE %s` to first check whether table exists in current catalog. If table exists in catalog, and data files under current path are valid, please use `CREATE TABLE IF NOT EXISTS` ddl instead. Otherwise, please choose another table name or manually delete the current path and try again.", path, context.getObjectIdentifier().asSerializableString(), context.getObjectIdentifier().asSerializableString()));
            }
            path.getFileSystem().mkdirs(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (context.getCatalogTable().getResolvedSchema().getPrimaryKey().isPresent() && Objects.equals(WriteMode.APPEND_ONLY.toString(), options.getOrDefault(CoreOptions.WRITE_MODE.key(), ((WriteMode)((Object)CoreOptions.WRITE_MODE.defaultValue())).toString()))) {
            throw new TableException("Cannot define any primary key in an append-only table. Set 'write-mode'='change-log' if still want to keep the primary key definition.");
        }
        try {
            new SchemaManager(path).commitNewVersion(UpdateSchema.fromCatalogTable((CatalogTable)context.getCatalogTable()));
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TableStoreManagedFactory.createOptionalLogStoreFactory(context).ifPresent(factory -> factory.onCreateTable(context, Integer.parseInt(options.getOrDefault(CoreOptions.BUCKET.key(), ((Integer)CoreOptions.BUCKET.defaultValue()).toString())), ignoreIfExists));
    }

    public void onDropTable(DynamicTableFactory.Context context, boolean ignoreIfNotExists) {
        Path path = CoreOptions.path(context.getCatalogTable().getOptions());
        try {
            if (path.getFileSystem().exists(path)) {
                path.getFileSystem().delete(path, true);
            } else if (!ignoreIfNotExists) {
                throw new TableException(String.format("Failed to delete file store path. Reason: directory %s doesn't exist for table %s. Suggestion: please try `DROP TABLE IF EXISTS` ddl instead.", path, context.getObjectIdentifier().asSerializableString()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        TableStoreManagedFactory.createOptionalLogStoreFactory(context).ifPresent(factory -> factory.onDropTable(context, ignoreIfNotExists));
    }

    public Map<String, String> onCompactTable(DynamicTableFactory.Context context, CatalogPartitionSpec catalogPartitionSpec) {
        HashMap<String, String> newOptions = new HashMap<String, String>(context.getCatalogTable().getOptions());
        newOptions.put(FlinkConnectorOptions.COMPACTION_MANUAL_TRIGGERED.key(), String.valueOf(true));
        newOptions.put(FlinkConnectorOptions.COMPACTION_PARTITION_SPEC.key(), JsonSerdeUtil.toJson(catalogPartitionSpec.getPartitionSpec()));
        return newOptions;
    }
}

