/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.utils;

import java.util.Arrays;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;

public class KeyProjectedRowData
implements RowData {
    private final int[] indexMapping;
    private RowData row;

    public KeyProjectedRowData(int[] indexMapping) {
        this.indexMapping = indexMapping;
    }

    public KeyProjectedRowData replaceRow(RowData row) {
        this.row = row;
        return this;
    }

    public int getArity() {
        return this.indexMapping.length;
    }

    public RowKind getRowKind() {
        return RowKind.INSERT;
    }

    public void setRowKind(RowKind kind) {
        throw new UnsupportedOperationException("Key row data should always be insert only.");
    }

    public boolean isNullAt(int pos) {
        return this.row.isNullAt(this.indexMapping[pos]);
    }

    public boolean getBoolean(int pos) {
        return this.row.getBoolean(this.indexMapping[pos]);
    }

    public byte getByte(int pos) {
        return this.row.getByte(this.indexMapping[pos]);
    }

    public short getShort(int pos) {
        return this.row.getShort(this.indexMapping[pos]);
    }

    public int getInt(int pos) {
        return this.row.getInt(this.indexMapping[pos]);
    }

    public long getLong(int pos) {
        return this.row.getLong(this.indexMapping[pos]);
    }

    public float getFloat(int pos) {
        return this.row.getFloat(this.indexMapping[pos]);
    }

    public double getDouble(int pos) {
        return this.row.getDouble(this.indexMapping[pos]);
    }

    public StringData getString(int pos) {
        return this.row.getString(this.indexMapping[pos]);
    }

    public DecimalData getDecimal(int pos, int precision, int scale) {
        return this.row.getDecimal(this.indexMapping[pos], precision, scale);
    }

    public TimestampData getTimestamp(int pos, int precision) {
        return this.row.getTimestamp(this.indexMapping[pos], precision);
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        return this.row.getRawValue(this.indexMapping[pos]);
    }

    public byte[] getBinary(int pos) {
        return this.row.getBinary(this.indexMapping[pos]);
    }

    public ArrayData getArray(int pos) {
        return this.row.getArray(this.indexMapping[pos]);
    }

    public MapData getMap(int pos) {
        return this.row.getMap(this.indexMapping[pos]);
    }

    public RowData getRow(int pos, int numFields) {
        return this.row.getRow(this.indexMapping[pos], numFields);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Projected row data cannot be compared");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Projected row data cannot be hashed");
    }

    public String toString() {
        return this.getRowKind().shortString() + "{indexMapping=" + Arrays.toString(this.indexMapping) + ", mutableRow=" + this.row + '}';
    }
}

