/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.connector.kafka.source.enumerator.subscriber;

import java.util.Map;
import java.util.Set;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.TopicDescription;

class KafkaSubscriberUtils {
    private KafkaSubscriberUtils() {
    }

    static Map<String, TopicDescription> getAllTopicMetadata(AdminClient adminClient) {
        try {
            Set<String> allTopicNames = adminClient.listTopics().names().get();
            return KafkaSubscriberUtils.getTopicMetadata(adminClient, allTopicNames);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get metadata for all topics.", e);
        }
    }

    static Map<String, TopicDescription> getTopicMetadata(AdminClient adminClient, Set<String> topicNames) {
        try {
            return adminClient.describeTopics(topicNames).all().get();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to get metadata for topics %s.", topicNames), e);
        }
    }
}

