/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.collector.ListenableCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.join.lookup.LookupJoinRunner;
import org.apache.flink.util.Collector;

public class LookupJoinWithCalcRunner
extends LookupJoinRunner {
    private static final long serialVersionUID = 5277183384939603386L;
    private final GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedCalc;
    private transient FlatMapFunction<RowData, RowData> calc;
    private transient Collector<RowData> calcCollector;

    public LookupJoinWithCalcRunner(GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher, GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedCalc, GeneratedCollector<ListenableCollector<RowData>> generatedCollector, boolean isLeftOuterJoin, int tableFieldsCount) {
        super(generatedFetcher, generatedCollector, isLeftOuterJoin, tableFieldsCount);
        this.generatedCalc = generatedCalc;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.calc = (FlatMapFunction)this.generatedCalc.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.calc, this.getRuntimeContext());
        FunctionUtils.openFunction(this.calc, parameters);
        this.calcCollector = new CalcCollector(this.collector);
    }

    @Override
    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.calc);
    }

    @Override
    public Collector<RowData> getFetcherCollector() {
        return this.calcCollector;
    }

    private class CalcCollector
    implements Collector<RowData> {
        private final Collector<RowData> delegate;

        private CalcCollector(Collector<RowData> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void collect(RowData record) {
            try {
                LookupJoinWithCalcRunner.this.calc.flatMap(record, this.delegate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }
}

