/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store;

import java.time.Duration;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.store.table.TableType;

public class CatalogOptions {
    public static final ConfigOption<String> WAREHOUSE = ConfigOptions.key("warehouse").stringType().noDefaultValue().withDescription("The warehouse root path of catalog.");
    public static final ConfigOption<String> METASTORE = ConfigOptions.key("metastore").stringType().defaultValue("filesystem").withDescription("Metastore of table store catalog, supports filesystem and hive.");
    public static final ConfigOption<String> URI = ConfigOptions.key("uri").stringType().noDefaultValue().withDescription("Uri of metastore server.");
    public static final ConfigOption<TableType> TABLE_TYPE = ConfigOptions.key("table.type").enumType(TableType.class).defaultValue(TableType.MANAGED).withDescription("Type of table.");
    public static final ConfigOption<Boolean> LOCK_ENABLED = ConfigOptions.key("lock.enabled").booleanType().defaultValue(false).withDescription("Enable Catalog Lock.");
    public static final ConfigOption<Duration> LOCK_CHECK_MAX_SLEEP = ConfigOptions.key("lock-check-max-sleep").durationType().defaultValue(Duration.ofSeconds(8L)).withDescription("The maximum sleep time when retrying to check the lock.");
    public static final ConfigOption<Duration> LOCK_ACQUIRE_TIMEOUT = ConfigOptions.key("lock-acquire-timeout").durationType().defaultValue(Duration.ofMinutes(8L)).withDescription("The maximum time to wait for acquiring the lock.");

    private CatalogOptions() {
    }
}

