/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class RawType<T>
extends LogicalType {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT = "RAW('%s', '%s')";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = RawType.conversionSet(byte[].class.getName(), RawValueData.class.getName());
    private final Class<T> clazz;
    private final TypeSerializer<T> serializer;
    private transient String serializerString;

    public RawType(boolean isNullable, Class<T> clazz, TypeSerializer<T> serializer) {
        super(isNullable, LogicalTypeRoot.RAW);
        this.clazz = Preconditions.checkNotNull(clazz, "Class must not be null.");
        this.serializer = Preconditions.checkNotNull(serializer, "Serializer must not be null.");
    }

    public RawType(Class<T> clazz, TypeSerializer<T> serializer) {
        this(true, clazz, serializer);
    }

    public Class<T> getOriginatingClass() {
        return this.clazz;
    }

    public TypeSerializer<T> getTypeSerializer() {
        return this.serializer;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new RawType<T>(isNullable, this.clazz, this.serializer.duplicate());
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.clazz.getName(), "...");
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.clazz.getName(), this.getSerializerString());
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return this.clazz.isAssignableFrom(clazz) || INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return clazz.isAssignableFrom(this.clazz) || INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return this.clazz;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RawType rawType = (RawType)o;
        return this.clazz.equals(rawType.clazz) && this.serializer.equals(rawType.serializer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clazz, this.serializer);
    }

    public static RawType<?> restore(ClassLoader classLoader, String className, String serializerString) {
        try {
            Class<?> clazz = Class.forName(className, true, classLoader);
            byte[] bytes = EncodingUtils.decodeBase64ToBytes(serializerString);
            DataInputDeserializer inputDeserializer = new DataInputDeserializer(bytes);
            TypeSerializerSnapshot snapshot = TypeSerializerSnapshot.readVersionedSnapshot(inputDeserializer, classLoader);
            return new RawType(clazz, snapshot.restoreSerializer());
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Unable to restore the RAW type of class '%s' with serializer snapshot '%s'.", className, serializerString), t);
        }
    }

    public String getSerializerString() {
        if (this.serializerString == null) {
            DataOutputSerializer outputSerializer = new DataOutputSerializer(128);
            try {
                TypeSerializerSnapshot.writeVersionedSnapshot(outputSerializer, this.serializer.snapshotConfiguration());
                this.serializerString = EncodingUtils.encodeBytesToBase64(outputSerializer.getCopyOfBuffer());
                return this.serializerString;
            }
            catch (Exception e) {
                throw new TableException(String.format("Unable to generate a string representation of the serializer snapshot of '%s' describing the class '%s' for the RAW type.", this.serializer.getClass().getName(), this.clazz.toString()), e);
            }
        }
        return this.serializerString;
    }
}

