/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source.snapshot;

import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.DataTable;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.snapshot.CompactedStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.CompactionChangelogFollowUpScanner;
import org.apache.flink.table.store.table.source.snapshot.ContinuousFromSnapshotStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.ContinuousFromTimestampStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.ContinuousLatestStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.DeltaFollowUpScanner;
import org.apache.flink.table.store.table.source.snapshot.FollowUpScanner;
import org.apache.flink.table.store.table.source.snapshot.FullStartingScanner;
import org.apache.flink.table.store.table.source.snapshot.InputChangelogFollowUpScanner;
import org.apache.flink.table.store.table.source.snapshot.SnapshotEnumerator;
import org.apache.flink.table.store.table.source.snapshot.StartingScanner;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousDataFileSnapshotEnumerator
implements SnapshotEnumerator {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousDataFileSnapshotEnumerator.class);
    private final SnapshotManager snapshotManager;
    private final DataTableScan scan;
    private final StartingScanner startingScanner;
    private final FollowUpScanner followUpScanner;
    @Nullable
    private Long nextSnapshotId;

    public ContinuousDataFileSnapshotEnumerator(Path tablePath, DataTableScan scan, StartingScanner startingScanner, FollowUpScanner followUpScanner, @Nullable Long nextSnapshotId) {
        this.snapshotManager = new SnapshotManager(tablePath);
        this.scan = scan;
        this.startingScanner = startingScanner;
        this.followUpScanner = followUpScanner;
        this.nextSnapshotId = nextSnapshotId;
    }

    @Override
    @Nullable
    public DataTableScan.DataFilePlan enumerate() {
        if (this.nextSnapshotId == null) {
            return this.tryFirstEnumerate();
        }
        return this.nextEnumerate();
    }

    private DataTableScan.DataFilePlan tryFirstEnumerate() {
        DataTableScan.DataFilePlan plan = this.startingScanner.getPlan(this.snapshotManager, this.scan);
        if (plan != null) {
            this.nextSnapshotId = plan.snapshotId + 1L;
        }
        return plan;
    }

    private DataTableScan.DataFilePlan nextEnumerate() {
        while (true) {
            Long l;
            if (!this.snapshotManager.snapshotExists(this.nextSnapshotId)) {
                LOG.debug("Next snapshot id {} does not exist, wait for the snapshot generation.", (Object)this.nextSnapshotId);
                return null;
            }
            Snapshot snapshot = this.snapshotManager.snapshot(this.nextSnapshotId);
            if (this.followUpScanner.shouldScanSnapshot(snapshot)) {
                LOG.debug("Find snapshot id {}.", (Object)this.nextSnapshotId);
                DataTableScan.DataFilePlan plan = this.followUpScanner.getPlan(this.nextSnapshotId, this.scan);
                l = this.nextSnapshotId;
                Long l2 = this.nextSnapshotId = Long.valueOf(this.nextSnapshotId + 1L);
                return plan;
            }
            Long l3 = this.nextSnapshotId;
            l = this.nextSnapshotId = Long.valueOf(this.nextSnapshotId + 1L);
        }
    }

    public static ContinuousDataFileSnapshotEnumerator createWithSnapshotStarting(DataTable table, DataTableScan scan) {
        StartingScanner startingScanner = table.options().startupMode() == CoreOptions.StartupMode.COMPACTED_FULL ? new CompactedStartingScanner() : new FullStartingScanner();
        return new ContinuousDataFileSnapshotEnumerator(table.location(), scan, startingScanner, ContinuousDataFileSnapshotEnumerator.createFollowUpScanner(table, scan), null);
    }

    public static ContinuousDataFileSnapshotEnumerator create(DataTable table, DataTableScan scan, @Nullable Long nextSnapshotId) {
        return new ContinuousDataFileSnapshotEnumerator(table.location(), scan, ContinuousDataFileSnapshotEnumerator.createStartingScanner(table), ContinuousDataFileSnapshotEnumerator.createFollowUpScanner(table, scan), nextSnapshotId);
    }

    private static StartingScanner createStartingScanner(DataTable table) {
        CoreOptions.StartupMode startupMode = table.options().startupMode();
        Long startupMillis = table.options().scanTimestampMills();
        if (startupMode == CoreOptions.StartupMode.LATEST_FULL) {
            return new FullStartingScanner();
        }
        if (startupMode == CoreOptions.StartupMode.LATEST) {
            return new ContinuousLatestStartingScanner();
        }
        if (startupMode == CoreOptions.StartupMode.COMPACTED_FULL) {
            return new CompactedStartingScanner();
        }
        if (startupMode == CoreOptions.StartupMode.FROM_TIMESTAMP) {
            Preconditions.checkNotNull(startupMillis, String.format("%s can not be null when you use %s for %s", CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), CoreOptions.StartupMode.FROM_TIMESTAMP, CoreOptions.SCAN_MODE.key()));
            return new ContinuousFromTimestampStartingScanner(startupMillis);
        }
        if (startupMode == CoreOptions.StartupMode.FROM_SNAPSHOT) {
            Long snapshotId = table.options().scanSnapshotId();
            Preconditions.checkNotNull(snapshotId, String.format("%s can not be null when you use %s for %s", CoreOptions.SCAN_SNAPSHOT_ID.key(), CoreOptions.StartupMode.FROM_SNAPSHOT, CoreOptions.SCAN_MODE.key()));
            return new ContinuousFromSnapshotStartingScanner(snapshotId);
        }
        throw new UnsupportedOperationException("Unknown startup mode " + startupMode.name());
    }

    private static FollowUpScanner createFollowUpScanner(DataTable table, DataTableScan scan) {
        CoreOptions.ChangelogProducer changelogProducer = table.options().changelogProducer();
        if (changelogProducer == CoreOptions.ChangelogProducer.NONE) {
            return new DeltaFollowUpScanner();
        }
        if (changelogProducer == CoreOptions.ChangelogProducer.INPUT) {
            return new InputChangelogFollowUpScanner();
        }
        if (changelogProducer == CoreOptions.ChangelogProducer.FULL_COMPACTION) {
            scan.withLevel(table.options().numLevels() - 1);
            return new CompactionChangelogFollowUpScanner();
        }
        throw new UnsupportedOperationException("Unknown changelog producer " + changelogProducer.name());
    }

    public static void validate(TableSchema schema) {
        CoreOptions options = new CoreOptions(schema.options());
        CoreOptions.MergeEngine mergeEngine = options.mergeEngine();
        HashMap<CoreOptions.MergeEngine, String> mergeEngineDesc = new HashMap<CoreOptions.MergeEngine, String>(){
            {
                this.put(CoreOptions.MergeEngine.PARTIAL_UPDATE, "Partial update");
                this.put(CoreOptions.MergeEngine.AGGREGATE, "Pre-aggregate");
            }
        };
        if (schema.primaryKeys().size() > 0 && mergeEngineDesc.containsKey(mergeEngine) && options.changelogProducer() != CoreOptions.ChangelogProducer.FULL_COMPACTION) {
            throw new ValidationException((String)mergeEngineDesc.get(mergeEngine) + " continuous reading is not supported. You can use full compaction changelog producer to support streaming reading.");
        }
    }

    public static interface Factory
    extends Serializable {
        public ContinuousDataFileSnapshotEnumerator create(DataTable var1, DataTableScan var2, @Nullable Long var3);
    }
}

