/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.HashSet;
import java.util.Set;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;

public class DistributionConfigSnapshot
extends DistributionConfigImpl {
    private static final long serialVersionUID = 7445728132965092798L;
    private final Set modifiable = new HashSet(20);

    public DistributionConfigSnapshot(DistributionConfig dc) {
        super(dc);
        String[] attNames = dc.getAttributeNames();
        for (int i = 0; i < attNames.length; ++i) {
            if (!dc.isAttributeModifiable(attNames[i])) continue;
            this.modifiable.add(attNames[i]);
        }
    }

    @Override
    protected String _getUnmodifiableMsg(String name) {
        return String.format("The %s configuration attribute can not be modified while the system is running.", name);
    }

    @Override
    public boolean isAttributeModifiable(String name) {
        this.checkAttributeName(name);
        return this.modifiable.contains(name);
    }

    @Override
    protected boolean _modifiableDefault() {
        return true;
    }
}

