/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.InvalidObjectException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import org.apache.geode.management.internal.OpenTypeConverter;

public class ArrayConverter
extends OpenTypeConverter {
    private final OpenTypeConverter elementConverter;

    ArrayConverter(Type targetType, ArrayType openArrayType, Class openArrayClass, OpenTypeConverter elementConverter) {
        super(targetType, openArrayType, openArrayClass);
        this.elementConverter = elementConverter;
    }

    @Override
    Object toNonNullOpenValue(Object value) throws OpenDataException {
        Object[] valueArray = (Object[])value;
        int len = valueArray.length;
        Object[] openArray = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), len);
        for (int i = 0; i < len; ++i) {
            openArray[i] = this.elementConverter.toOpenValue(valueArray[i]);
        }
        return openArray;
    }

    @Override
    public Object fromNonNullOpenValue(Object openValue) throws InvalidObjectException {
        Class<?> componentType;
        Object[] openArray = (Object[])openValue;
        Type targetType = this.getTargetType();
        if (targetType instanceof GenericArrayType) {
            componentType = ((GenericArrayType)targetType).getGenericComponentType();
        } else if (targetType instanceof Class && ((Class)targetType).isArray()) {
            componentType = ((Class)targetType).getComponentType();
        } else {
            throw new IllegalArgumentException("Not an array: " + targetType);
        }
        Object[] valueArray = (Object[])Array.newInstance(componentType, openArray.length);
        for (int i = 0; i < openArray.length; ++i) {
            valueArray[i] = this.elementConverter.fromOpenValue(openArray[i]);
        }
        return valueArray;
    }

    @Override
    void checkReconstructible() throws InvalidObjectException {
        this.elementConverter.checkReconstructible();
    }
}

