/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class TestNGThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String name;
    private final Set<Thread> threads = Collections.newSetFromMap(new WeakHashMap());

    public TestNGThreadFactory(String name) {
        this.name = "TestNG-" + name + "-";
    }

    public Collection<Thread> getRunningThreads() {
        return this.threads.stream().filter(Thread::isAlive).collect(Collectors.toList());
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, this.name + this.threadNumber.getAndIncrement());
        this.threads.add(thread);
        return thread;
    }
}

