/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;

public class XPathContextMajor
extends XPathContextMinor {
    private StackFrame stackFrame = null;
    private ParameterSet localParameters = null;
    private XSLTContext xsltContext = null;

    public XPathContextMajor(Controller controller) {
        this.controller = controller;
        this.stackFrame = StackFrame.EMPTY;
        this.origin = this.controller;
    }

    private XPathContextMajor() {
    }

    public XPathContextMajor(Item item, Configuration configuration) {
        Executable executable = new Executable();
        executable.setHostLanguage(53);
        this.controller = new Controller(configuration, executable);
        AxisIterator axisIterator = SingletonIterator.makeIterator(item);
        axisIterator.next();
        this.currentIterator = axisIterator;
        this.origin = this.controller;
    }

    public XPathContextMajor newContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor();
        xPathContextMajor.controller = this.controller;
        xPathContextMajor.currentIterator = this.currentIterator;
        xPathContextMajor.stackFrame = this.stackFrame;
        xPathContextMajor.localParameters = this.localParameters;
        xPathContextMajor.last = this.last;
        xPathContextMajor.currentReceiver = this.currentReceiver;
        xPathContextMajor.isTemporaryDestination = this.isTemporaryDestination;
        xPathContextMajor.xsltContext = this.xsltContext;
        xPathContextMajor.caller = this;
        return xPathContextMajor;
    }

    public static XPathContextMajor newContext(XPathContextMinor xPathContextMinor) {
        XPathContextMajor xPathContextMajor = new XPathContextMajor();
        xPathContextMajor.controller = xPathContextMinor.getController();
        xPathContextMajor.currentIterator = xPathContextMinor.getCurrentIterator();
        xPathContextMajor.stackFrame = xPathContextMinor.getStackFrame();
        xPathContextMajor.localParameters = xPathContextMinor.getLocalParameters();
        xPathContextMajor.last = xPathContextMinor.last;
        xPathContextMajor.currentReceiver = xPathContextMinor.currentReceiver;
        xPathContextMajor.isTemporaryDestination = xPathContextMinor.isTemporaryDestination;
        xPathContextMajor.xsltContext = xPathContextMinor.getXSLTContext();
        xPathContextMajor.caller = xPathContextMinor;
        return xPathContextMajor;
    }

    public XSLTContext getXSLTContext() {
        return this.xsltContext;
    }

    public ParameterSet getLocalParameters() {
        return this.localParameters;
    }

    public void setLocalParameters(ParameterSet parameterSet) {
        this.localParameters = parameterSet;
    }

    public ParameterSet getTunnelParameters() {
        if (this.xsltContext != null) {
            return this.xsltContext.tunnelParameters;
        }
        return null;
    }

    public void setTunnelParameters(ParameterSet parameterSet) {
        this.xsltContext = new XSLTContext(this.xsltContext);
        this.xsltContext.tunnelParameters = parameterSet;
    }

    public void setOrigin(InstructionInfoProvider instructionInfoProvider) {
        this.origin = instructionInfoProvider;
    }

    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public void setStackFrame(SlotManager slotManager, ValueRepresentation[] valueRepresentationArray) {
        this.stackFrame = new StackFrame(slotManager, valueRepresentationArray);
        if (slotManager != null && valueRepresentationArray.length != slotManager.getNumberOfVariables()) {
            this.stackFrame.slots = new ValueRepresentation[slotManager.getNumberOfVariables()];
            System.arraycopy(valueRepresentationArray, 0, this.stackFrame.slots, 0, valueRepresentationArray.length);
        }
    }

    public void openStackFrame(SlotManager slotManager) {
        int n = slotManager.getNumberOfVariables();
        this.stackFrame = n == 0 ? StackFrame.EMPTY : new StackFrame(slotManager, new ValueRepresentation[n]);
    }

    public void openStackFrame(int n) {
        this.stackFrame = new StackFrame(null, new ValueRepresentation[n]);
    }

    public ValueRepresentation evaluateLocalVariable(int n) {
        return this.stackFrame.slots[n];
    }

    public void setLocalVariable(int n, ValueRepresentation valueRepresentation) {
        this.stackFrame.slots[n] = valueRepresentation;
    }

    public void setCurrentMode(Mode mode) {
        if (mode != null && !mode.isDefaultMode() || this.getCurrentMode() != null) {
            this.xsltContext = new XSLTContext(this.xsltContext);
            this.xsltContext.currentMode = mode;
        }
    }

    public Mode getCurrentMode() {
        if (this.xsltContext != null) {
            return this.xsltContext.currentMode;
        }
        return null;
    }

    public void setCurrentTemplate(Template template) {
        this.xsltContext = new XSLTContext(this.xsltContext);
        this.xsltContext.currentTemplate = template;
    }

    public Template getCurrentTemplate() {
        if (this.xsltContext != null) {
            return this.xsltContext.currentTemplate;
        }
        return null;
    }

    public void setCurrentGroupIterator(GroupIterator groupIterator) {
        this.xsltContext = new XSLTContext(this.xsltContext);
        this.xsltContext.currentGroupIterator = groupIterator;
    }

    public GroupIterator getCurrentGroupIterator() {
        if (this.xsltContext != null) {
            return this.xsltContext.currentGroupIterator;
        }
        return null;
    }

    public void setCurrentRegexIterator(RegexIterator regexIterator) {
        this.xsltContext = new XSLTContext(this.xsltContext);
        this.xsltContext.currentJRegexIterator = regexIterator;
    }

    public RegexIterator getCurrentRegexIterator() {
        if (this.xsltContext != null) {
            return this.xsltContext.currentJRegexIterator;
        }
        return null;
    }

    public boolean useLocalParameter(int n, LocalParam localParam, boolean bl) throws XPathException {
        ValueRepresentation valueRepresentation;
        ParameterSet parameterSet;
        ParameterSet parameterSet2 = parameterSet = bl ? this.getTunnelParameters() : this.localParameters;
        if (parameterSet == null) {
            return false;
        }
        this.stackFrame.slots[localParam.getSlotNumber()] = valueRepresentation = parameterSet.get(n);
        return valueRepresentation != null;
    }

    protected static class XSLTContext {
        public ParameterSet tunnelParameters = null;
        public Mode currentMode = null;
        public Template currentTemplate = null;
        public GroupIterator currentGroupIterator = null;
        public RegexIterator currentJRegexIterator = null;

        public XSLTContext(XSLTContext xSLTContext) {
            if (xSLTContext != null) {
                this.tunnelParameters = xSLTContext.tunnelParameters;
                this.currentMode = xSLTContext.currentMode;
                this.currentTemplate = xSLTContext.currentTemplate;
                this.currentGroupIterator = xSLTContext.currentGroupIterator;
                this.currentJRegexIterator = xSLTContext.currentJRegexIterator;
            }
        }
    }
}

