/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.microsoft.chm.ChmExtractor;
import org.apache.tika.parser.microsoft.chm.DirectoryListingEntry;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ChmParser
extends AbstractParser {
    private static final long serialVersionUID = 5938777307516469802L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.ms-htmlhelp"), MediaType.application((String)"chm"), MediaType.application((String)"x-chm"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ChmExtractor chmExtractor = new ChmExtractor(stream);
        metadata.set("Content-Type", "application/vnd.ms-htmlhelp");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        Parser htmlParser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(HtmlParser.class, (ParseContext)context);
        if (htmlParser == null) {
            htmlParser = new HtmlParser();
        }
        for (DirectoryListingEntry entry : chmExtractor.getChmDirList().getDirectoryListingEntryList()) {
            String entryName = entry.getName();
            if (!entryName.endsWith(".html") && !entryName.endsWith(".htm")) continue;
            byte[] data = chmExtractor.extractChmEntry(entry);
            this.parsePage(data, htmlParser, (ContentHandler)xhtml, context);
        }
        xhtml.endDocument();
    }

    private void parsePage(byte[] byteObject, Parser htmlParser, ContentHandler xhtml, ParseContext context) throws TikaException, SAXException {
        UnsynchronizedByteArrayInputStream stream = null;
        Metadata metadata = new Metadata();
        EmbeddedContentHandler handler = new EmbeddedContentHandler((ContentHandler)new BodyContentHandler(xhtml));
        try {
            stream = new UnsynchronizedByteArrayInputStream(byteObject);
            htmlParser.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

