/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.storage.control.v2.Folder;
import javax.annotation.Nonnull;

@VisibleForTesting
public class FolderInfo {
    public static final String BUCKET_PREFIX = "projects/_/buckets/";
    public static final String FOLDER_PREFIX = "/folders/";
    public static final String PATH = "/";
    private final String bucket;
    private final String folderName;

    public FolderInfo(@Nonnull Folder folder) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)folder.getName()) ? 1 : 0) != 0, (String)"Folder resource has invalid path : %s", (Object)folder.getName());
        this.bucket = this.getBucketString(folder.getName());
        this.folderName = this.getFolderString(folder.getName());
    }

    public static Folder createFolderInfoObject(String bucketName, String folderName) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (String)"Folder resource has invalid bucket name: %s", (Object)bucketName);
        Preconditions.checkState((folderName != null ? 1 : 0) != 0, (String)"Folder resource has invalid folder name: %s", (Object)folderName);
        String suffix = folderName.equals("") ? "" : (folderName.endsWith(PATH) ? "" : PATH);
        return Folder.newBuilder().setName(String.join((CharSequence)"", BUCKET_PREFIX, bucketName, FOLDER_PREFIX, folderName, suffix)).build();
    }

    private String getBucketString(String path) {
        Preconditions.checkState((boolean)path.startsWith(BUCKET_PREFIX), (String)"Invalid bucket resource name. Bucket resource name must begin with 'projects/_/buckets/' for global-namespaced buckets and contain no invalid characters or patterns : %s", (Object)path);
        int startIndexOfBucketPrefix = path.indexOf(BUCKET_PREFIX) + BUCKET_PREFIX.length();
        return path.substring(startIndexOfBucketPrefix, path.indexOf(PATH, startIndexOfBucketPrefix));
    }

    private String getFolderString(String path) {
        Preconditions.checkState((boolean)path.contains(FOLDER_PREFIX), (String)"Invalid folder path: %s", (Object)path);
        int startIndex = path.indexOf(FOLDER_PREFIX) + FOLDER_PREFIX.length();
        return path.substring(startIndex);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public boolean isBucket() {
        return this.folderName.equals("");
    }

    public String getParentFolderName() {
        int lastIndex = this.folderName.lastIndexOf(PATH, this.folderName.length() - 2);
        return this.folderName.substring(0, lastIndex + 1);
    }

    public String toString() {
        return String.join((CharSequence)"", BUCKET_PREFIX, this.bucket, FOLDER_PREFIX, this.folderName);
    }
}

