/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.http2.hpack;

import com.clickhouse.client.internal.org.apache.hc.core5.http.Header;
import com.clickhouse.client.internal.org.apache.hc.core5.http2.hpack.FifoLinkedList;
import com.clickhouse.client.internal.org.apache.hc.core5.http2.hpack.HPackEntry;
import com.clickhouse.client.internal.org.apache.hc.core5.http2.hpack.HPackHeader;
import com.clickhouse.client.internal.org.apache.hc.core5.http2.hpack.StaticTable;
import com.clickhouse.client.internal.org.apache.hc.core5.util.Args;
import com.clickhouse.client.internal.org.apache.hc.core5.util.Asserts;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class OutboundDynamicTable {
    private final StaticTable staticTable;
    private final FifoLinkedList headers;
    private final Map<String, LinkedList<HPackEntry>> mapByName;
    private int maxSize;
    private int currentSize;

    OutboundDynamicTable(int maxSize, StaticTable staticTable) {
        this.staticTable = staticTable;
        this.headers = new FifoLinkedList();
        this.mapByName = new HashMap<String, LinkedList<HPackEntry>>();
        this.maxSize = maxSize;
        this.currentSize = 0;
    }

    OutboundDynamicTable(int maxSize) {
        this(maxSize, StaticTable.INSTANCE);
    }

    OutboundDynamicTable() {
        this(Integer.MAX_VALUE);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.evict();
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    int staticLength() {
        return this.staticTable.length();
    }

    int dynamicLength() {
        return this.headers.size();
    }

    Header getDynamicEntry(int index) {
        return this.headers.get(index);
    }

    public int length() {
        return this.staticTable.length() + this.headers.size();
    }

    public Header getHeader(int index) {
        int length = this.length();
        Args.check(index >= 1, "index %s cannot be less then 1", (Object)index);
        Args.check(index <= length, "index %s cannot be greater then length %s ", index, length);
        return index <= this.staticTable.length() ? this.staticTable.get(index) : this.headers.get(index - this.staticTable.length() - 1);
    }

    public void add(HPackHeader header) {
        int entrySize = header.getTotalSize();
        if (entrySize > this.maxSize) {
            this.clear();
            this.mapByName.clear();
            return;
        }
        String key = header.getName();
        FifoLinkedList.InternalNode node = this.headers.addFirst(header);
        LinkedList nodes = this.mapByName.computeIfAbsent(key, k -> new LinkedList());
        nodes.addFirst(node);
        this.currentSize += entrySize;
        this.evict();
    }

    private void clear() {
        this.currentSize = 0;
        this.headers.clear();
    }

    public List<HPackEntry> getByName(String key) {
        return this.mapByName.get(key);
    }

    private void evict() {
        while (this.currentSize > this.maxSize) {
            FifoLinkedList.InternalNode node = this.headers.removeLast();
            if (node != null) {
                HPackHeader header = node.getHeader();
                this.currentSize -= header.getTotalSize();
                String key = header.getName();
                LinkedList<HPackEntry> nodes = this.mapByName.get(key);
                if (nodes == null) continue;
                nodes.remove(node);
                continue;
            }
            Asserts.check(this.currentSize == 0, "Current table size must be zero");
            break;
        }
    }
}

