/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.data_formats.internal.InetAddressConverter;
import com.clickhouse.client.internal.com.google.common.collect.ImmutableMap;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.Tuple;
import com.clickhouse.jdbc.types.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class JdbcUtils {
    public static final Map<ClickHouseDataType, SQLType> CLICKHOUSE_TO_SQL_TYPE_MAP = JdbcUtils.generateTypeMap();
    public static final Map<String, SQLType> CLICKHOUSE_TYPE_NAME_TO_SQL_TYPE_MAP = Collections.unmodifiableMap(JdbcUtils.generateTypeMap().entrySet().stream().collect(HashMap::new, (map, entry) -> map.put(((ClickHouseDataType)entry.getKey()).name(), (SQLType)entry.getValue()), HashMap::putAll));
    public static final Map<SQLType, Class<?>> SQL_TYPE_TO_CLASS_MAP = JdbcUtils.generateClassMap();
    public static final Set<ClickHouseDataType> INVALID_TARGET_TYPES = EnumSet.of(ClickHouseDataType.Nested, new ClickHouseDataType[]{ClickHouseDataType.Enum8, ClickHouseDataType.Enum16, ClickHouseDataType.Enum, ClickHouseDataType.Tuple, ClickHouseDataType.Map, ClickHouseDataType.Nothing, ClickHouseDataType.Nullable, ClickHouseDataType.Variant});
    public static final Map<ClickHouseDataType, Class<?>> DATA_TYPE_CLASS_MAP = JdbcUtils.getDataTypeClassMap();
    public static final Map<SQLType, ClickHouseDataType> SQL_TO_CLICKHOUSE_TYPE_MAP = JdbcUtils.createSQLToClickHouseDataTypeMap();

    private static Map<ClickHouseDataType, SQLType> generateTypeMap() {
        TreeMap<ClickHouseDataType, JDBCType> map = new TreeMap<ClickHouseDataType, JDBCType>();
        map.put(ClickHouseDataType.Int8, JDBCType.TINYINT);
        map.put(ClickHouseDataType.Int16, JDBCType.SMALLINT);
        map.put(ClickHouseDataType.Int32, JDBCType.INTEGER);
        map.put(ClickHouseDataType.Int64, JDBCType.BIGINT);
        map.put(ClickHouseDataType.Int128, JDBCType.OTHER);
        map.put(ClickHouseDataType.Int256, JDBCType.OTHER);
        map.put(ClickHouseDataType.UInt8, JDBCType.SMALLINT);
        map.put(ClickHouseDataType.UInt16, JDBCType.INTEGER);
        map.put(ClickHouseDataType.UInt32, JDBCType.BIGINT);
        map.put(ClickHouseDataType.UInt64, JDBCType.OTHER);
        map.put(ClickHouseDataType.UInt128, JDBCType.OTHER);
        map.put(ClickHouseDataType.UInt256, JDBCType.OTHER);
        map.put(ClickHouseDataType.Float32, JDBCType.FLOAT);
        map.put(ClickHouseDataType.Float64, JDBCType.DOUBLE);
        map.put(ClickHouseDataType.Bool, JDBCType.BOOLEAN);
        map.put(ClickHouseDataType.Decimal, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.Decimal32, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.Decimal64, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.Decimal128, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.String, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.FixedString, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Enum, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Enum8, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Enum16, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Date, JDBCType.DATE);
        map.put(ClickHouseDataType.Date32, JDBCType.DATE);
        map.put(ClickHouseDataType.DateTime, JDBCType.TIMESTAMP);
        map.put(ClickHouseDataType.DateTime32, JDBCType.TIMESTAMP);
        map.put(ClickHouseDataType.DateTime64, JDBCType.TIMESTAMP);
        map.put(ClickHouseDataType.Array, JDBCType.ARRAY);
        map.put(ClickHouseDataType.Nested, JDBCType.ARRAY);
        map.put(ClickHouseDataType.Map, JDBCType.JAVA_OBJECT);
        map.put(ClickHouseDataType.Point, JDBCType.OTHER);
        map.put(ClickHouseDataType.Ring, JDBCType.OTHER);
        map.put(ClickHouseDataType.Polygon, JDBCType.OTHER);
        map.put(ClickHouseDataType.LineString, JDBCType.OTHER);
        map.put(ClickHouseDataType.MultiPolygon, JDBCType.OTHER);
        map.put(ClickHouseDataType.MultiLineString, JDBCType.OTHER);
        return ImmutableMap.copyOf(map);
    }

    private static Map<SQLType, Class<?>> generateClassMap() {
        HashMap<JDBCType, Class<SQLXML>> map = new HashMap<JDBCType, Class<SQLXML>>();
        map.put(JDBCType.CHAR, String.class);
        map.put(JDBCType.VARCHAR, String.class);
        map.put(JDBCType.LONGVARCHAR, String.class);
        map.put(JDBCType.NUMERIC, BigDecimal.class);
        map.put(JDBCType.DECIMAL, BigDecimal.class);
        map.put(JDBCType.BIT, Boolean.class);
        map.put(JDBCType.BOOLEAN, Boolean.class);
        map.put(JDBCType.TINYINT, Byte.class);
        map.put(JDBCType.SMALLINT, Short.class);
        map.put(JDBCType.INTEGER, Integer.class);
        map.put(JDBCType.BIGINT, Long.class);
        map.put(JDBCType.REAL, Float.class);
        map.put(JDBCType.FLOAT, Double.class);
        map.put(JDBCType.DOUBLE, Double.class);
        map.put(JDBCType.BINARY, byte[].class);
        map.put(JDBCType.VARBINARY, byte[].class);
        map.put(JDBCType.LONGVARBINARY, byte[].class);
        map.put(JDBCType.DATE, Date.class);
        map.put(JDBCType.TIME, Time.class);
        map.put(JDBCType.TIMESTAMP, Timestamp.class);
        map.put(JDBCType.TIME_WITH_TIMEZONE, Time.class);
        map.put(JDBCType.TIMESTAMP_WITH_TIMEZONE, Timestamp.class);
        map.put(JDBCType.CLOB, Clob.class);
        map.put(JDBCType.BLOB, Blob.class);
        map.put(JDBCType.ARRAY, java.sql.Array.class);
        map.put(JDBCType.STRUCT, Struct.class);
        map.put(JDBCType.REF, Ref.class);
        map.put(JDBCType.DATALINK, URL.class);
        map.put(JDBCType.ROWID, RowId.class);
        map.put(JDBCType.NCHAR, String.class);
        map.put(JDBCType.NVARCHAR, String.class);
        map.put(JDBCType.LONGNVARCHAR, String.class);
        map.put(JDBCType.NCLOB, NClob.class);
        map.put(JDBCType.SQLXML, SQLXML.class);
        return ImmutableMap.copyOf(map);
    }

    private static Map<ClickHouseDataType, Class<?>> getDataTypeClassMap() {
        HashMap map = new HashMap();
        block11: for (Map.Entry<ClickHouseDataType, SQLType> e : CLICKHOUSE_TO_SQL_TYPE_MAP.entrySet()) {
            if (e.getValue().equals(JDBCType.OTHER)) {
                switch (e.getKey()) {
                    case UInt64: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case UInt128: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case UInt256: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case Int128: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case Int256: {
                        map.put(e.getKey(), BigInteger.class);
                        continue block11;
                    }
                    case Point: {
                        map.put(e.getKey(), double[].class);
                        continue block11;
                    }
                    case LineString: 
                    case Ring: {
                        map.put(e.getKey(), double[][].class);
                        continue block11;
                    }
                    case Polygon: 
                    case MultiLineString: {
                        map.put(e.getKey(), double[][][].class);
                        continue block11;
                    }
                    case MultiPolygon: {
                        map.put(e.getKey(), double[][][][].class);
                        continue block11;
                    }
                }
                map.put(e.getKey(), Object.class);
                continue;
            }
            map.put(e.getKey(), SQL_TYPE_TO_CLASS_MAP.get(e.getValue()));
        }
        return map;
    }

    private static Map<SQLType, ClickHouseDataType> createSQLToClickHouseDataTypeMap() {
        HashMap<JDBCType, ClickHouseDataType> map = new HashMap<JDBCType, ClickHouseDataType>();
        map.put(JDBCType.TINYINT, ClickHouseDataType.Int8);
        map.put(JDBCType.SMALLINT, ClickHouseDataType.Int16);
        map.put(JDBCType.INTEGER, ClickHouseDataType.Int32);
        map.put(JDBCType.BIGINT, ClickHouseDataType.Int64);
        map.put(JDBCType.FLOAT, ClickHouseDataType.Float32);
        map.put(JDBCType.REAL, ClickHouseDataType.Float32);
        map.put(JDBCType.DOUBLE, ClickHouseDataType.Float64);
        map.put(JDBCType.BOOLEAN, ClickHouseDataType.Bool);
        map.put(JDBCType.DATE, ClickHouseDataType.Date32);
        map.put(JDBCType.TIME, ClickHouseDataType.Time);
        map.put(JDBCType.TIMESTAMP, ClickHouseDataType.DateTime64);
        map.put(JDBCType.TIMESTAMP_WITH_TIMEZONE, ClickHouseDataType.DateTime64);
        map.put(JDBCType.BINARY, ClickHouseDataType.String);
        map.put(JDBCType.VARBINARY, ClickHouseDataType.String);
        map.put(JDBCType.LONGVARBINARY, ClickHouseDataType.String);
        map.put(JDBCType.CHAR, ClickHouseDataType.String);
        map.put(JDBCType.NCHAR, ClickHouseDataType.String);
        map.put(JDBCType.VARCHAR, ClickHouseDataType.String);
        map.put(JDBCType.LONGNVARCHAR, ClickHouseDataType.String);
        map.put(JDBCType.NVARCHAR, ClickHouseDataType.String);
        map.put(JDBCType.DECIMAL, ClickHouseDataType.Decimal32);
        map.put(JDBCType.ARRAY, ClickHouseDataType.Array);
        return Collections.unmodifiableMap(map);
    }

    public static SQLType convertToSqlType(ClickHouseDataType clickhouseType) {
        if (clickhouseType == null) {
            return JDBCType.OTHER;
        }
        return CLICKHOUSE_TO_SQL_TYPE_MAP.getOrDefault(clickhouseType, JDBCType.OTHER);
    }

    public static Class<?> convertToJavaClass(ClickHouseDataType clickhouseType) {
        return DATA_TYPE_CLASS_MAP.get(clickhouseType);
    }

    public static Object convert(Object value, Class<?> type) throws SQLException {
        return JdbcUtils.convert(value, type, null);
    }

    public static Object convert(Object value, Class<?> type, ClickHouseColumn column) throws SQLException {
        if (value == null || type == null) {
            return value;
        }
        try {
            if (type.isInstance(value)) {
                return value;
            }
            if (type != java.sql.Array.class && value instanceof List) {
                return JdbcUtils.convertList((List)value, type);
            }
            if (type == String.class) {
                return value.toString();
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return Boolean.parseBoolean(value.toString());
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return Byte.parseByte(value.toString());
            }
            if (type == Short.class || type == Short.TYPE) {
                return Short.parseShort(value.toString());
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return Integer.parseInt(value.toString());
            }
            if (type == Long.class || type == Long.TYPE) {
                return Long.parseLong(value.toString());
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value.toString()));
            }
            if (type == Double.class || type == Double.TYPE) {
                return Double.parseDouble(value.toString());
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(value.toString());
            }
            if (type == byte[].class) {
                return value.toString().getBytes();
            }
            if (type == LocalDate.class && value instanceof TemporalAccessor) {
                return LocalDate.from((TemporalAccessor)value);
            }
            if (type == LocalDateTime.class && value instanceof TemporalAccessor) {
                return LocalDateTime.from((TemporalAccessor)value);
            }
            if (type == OffsetDateTime.class && value instanceof TemporalAccessor) {
                return OffsetDateTime.from((TemporalAccessor)value);
            }
            if (type == ZonedDateTime.class && value instanceof TemporalAccessor) {
                return ZonedDateTime.from((TemporalAccessor)value);
            }
            if (type == Date.class && value instanceof TemporalAccessor) {
                return Date.valueOf(LocalDate.from((TemporalAccessor)value));
            }
            if (type == Timestamp.class && value instanceof TemporalAccessor) {
                return Timestamp.valueOf(LocalDateTime.from((TemporalAccessor)value));
            }
            if (type == Time.class && value instanceof TemporalAccessor) {
                return Time.valueOf(LocalTime.from((TemporalAccessor)value));
            }
            if (type == java.sql.Array.class && value instanceof BinaryStreamReader.ArrayValue) {
                BinaryStreamReader.ArrayValue arrayValue = (BinaryStreamReader.ArrayValue)value;
                if (column != null && column.getArrayBaseColumn() != null) {
                    ClickHouseDataType baseType = column.getArrayBaseColumn().getDataType();
                    Object[] convertedValues = JdbcUtils.convertArray(arrayValue.getArrayOfObjects(), JdbcUtils.convertToJavaClass(baseType));
                    return new Array(column, convertedValues);
                }
                return new Array(column, arrayValue.getArrayOfObjects());
            }
            if (type == java.sql.Array.class && value instanceof List) {
                if (column != null && column.getArrayBaseColumn() != null) {
                    ClickHouseDataType baseType = column.getArrayBaseColumn().getDataType();
                    Object[] convertedValues = JdbcUtils.convertList((List)value, JdbcUtils.convertToJavaClass(baseType));
                    return new Array(column, convertedValues);
                }
                return new Array(column, ((List)value).toArray());
            }
            if (type == Inet4Address.class && value instanceof Inet6Address) {
                return InetAddressConverter.convertToIpv4((InetAddress)value);
            }
            if (type == Inet6Address.class && value instanceof Inet4Address) {
                return InetAddressConverter.convertToIpv6((InetAddress)value);
            }
            if (type == Tuple.class && value.getClass().isArray()) {
                return new Tuple(true, value);
            }
        }
        catch (Exception e) {
            throw new SQLException("Failed to convert from " + value.getClass().getName() + " to " + type.getName(), "22000", e);
        }
        throw new SQLException("Unsupported conversion from " + value.getClass().getName() + " to " + type.getName(), "22000");
    }

    public static Object[] convertList(List<?> values, Class<?> type) throws SQLException {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return new Object[0];
        }
        Object[] convertedValues = new Object[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            convertedValues[i] = JdbcUtils.convert(values.get(i), type);
        }
        return convertedValues;
    }

    public static Object[] convertArray(Object[] values, Class<?> type) throws SQLException {
        if (values == null || type == null) {
            return values;
        }
        Object[] convertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = JdbcUtils.convert(values[i], type);
        }
        return convertedValues;
    }
}

