/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IterableCoder<@UnknownKeyFor T>
extends IterableLikeCoder<T, Iterable<T>> {
    public static <T> @UnknownKeyFor @NonNull @Initialized IterableCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        return new IterableCoder<T>(elemCoder);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized Iterable<T> value) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (T elem : value) {
            result.add(this.getElemCoder().structuralValue(elem));
        }
        return result;
    }

    @Override
    protected final @UnknownKeyFor @NonNull @Initialized Iterable<T> decodeToIterable(@UnknownKeyFor @NonNull @Initialized List<T> decodedElements) {
        return decodedElements;
    }

    protected IterableCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        super(elemCoder, "Iterable");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Iterable<T>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<Iterable<T>>(){}.where(new TypeParameter<T>(){}, this.getElemCoder().getEncodedTypeDescriptor());
    }
}

