/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.splitfieldtorows;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.splitfieldtorows.SplitFieldToRows;
import org.apache.hop.pipeline.transforms.splitfieldtorows.SplitFieldToRowsData;

@Transform(id="SplitFieldToRows3", name="i18n::SplitFieldToRows.Name", image="splitfieldtorows.svg", description="i18n::SplitFieldToRows.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::SplitFieldToRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/splitfieldtorows.html")
public class SplitFieldToRowsMeta
extends BaseTransformMeta<SplitFieldToRows, SplitFieldToRowsData> {
    private static final Class<?> PKG = SplitFieldToRowsMeta.class;
    @HopMetadataProperty(key="splitfield", injectionKey="FIELD_TO_SPLIT", injectionKeyDescription="SplitFieldsToRow.Injection.FieldToSplit.Description")
    private String splitField;
    @HopMetadataProperty(injectionKey="DELIMITER", injectionKeyDescription="SplitFieldsToRow.Injection.Delimiter.Description")
    private String delimiter;
    @HopMetadataProperty(key="newfield", injectionKey="NEW_FIELD_NAME", injectionKeyDescription="SplitFieldsToRow.Injection.NewFieldname.Description")
    private String newFieldname;
    @HopMetadataProperty(key="rownum", injectionKey="INCLUDE_ROWNUM", injectionKeyDescription="SplitFieldsToRow.Injection.IncludeRowNum.Description")
    private boolean includeRowNumber;
    @HopMetadataProperty(key="rownum_field", injectionKey="ROWNUM_FIELD_NAME", injectionKeyDescription="SplitFieldsToRow.Injection.RownumFieldname.Description")
    private String rowNumberField;
    @HopMetadataProperty(key="resetrownumber", injectionKey="RESET_ROWNUM", injectionKeyDescription="SplitFieldsToRow.Injection.ResetRowNum.Description")
    private boolean resetRowNumber;
    @HopMetadataProperty(key="delimiter_is_regex", injectionKey="DELIMITER_IS_REGEX", injectionKeyDescription="SplitFieldsToRow.Injection.DelimiterIsRegexp.Description")
    private boolean isDelimiterRegex;

    public boolean isIsDelimiterRegex() {
        return this.isDelimiterRegex;
    }

    public void setIsDelimiterRegex(boolean isDelimiterRegex) {
        this.isDelimiterRegex = isDelimiterRegex;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getSplitField() {
        return this.splitField;
    }

    public void setSplitField(String splitField) {
        this.splitField = splitField;
    }

    public void setDefault() {
        this.splitField = "";
        this.delimiter = ";";
        this.newFieldname = "";
        this.includeRowNumber = false;
        this.isDelimiterRegex = false;
        this.rowNumberField = "";
        this.resetRowNumber = true;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v = new ValueMetaString(this.newFieldname);
        v.setOrigin(name);
        row.addValueMeta((IValueMeta)v);
        if (this.includeRowNumber) {
            v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            IValueMeta v = prev.searchValueMeta(this.splitField);
            if (v == null) {
                errorMessage = BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.FieldToSplitNotPresentInInputStream", (String[])new String[]{this.splitField});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.FieldToSplitFoundInInputStream", (String[])new String[]{this.splitField}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.TransformReceivingInfoFromOtherTransform", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.NoInputReceivedFromOtherTransform", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.newFieldname)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.NewFieldNameIsNull", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeRowNumber) {
            cr = Utils.isEmpty((CharSequence)variables.resolve(this.rowNumberField)) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.RowNumberFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.RowNumberFieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getNewFieldname() {
        return this.newFieldname;
    }

    public void setNewFieldname(String newFieldname) {
        this.newFieldname = newFieldname;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public boolean isResetRowNumber() {
        return this.resetRowNumber;
    }

    public void setResetRowNumber(boolean resetRowNumber) {
        this.resetRowNumber = resetRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public boolean isIncludeRowNumber() {
        return this.includeRowNumber;
    }
}

