/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.options;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface AzureOptions
extends PipelineOptions {
    @Description(value="The credential instance that should be used to authenticate against Azure services. The option value must contain \"@type\" field and an Azure credentials provider class name as the field value.  For example, to specify the Azure client id, tenant id, and client secret, specify the following: {\"@type\" : \"ClientSecretCredential\", \"azureClientId\": \"client_id_value\", \"azureTenantId\": \"tenant_id_value\", \"azureClientSecret\": \"client_secret_value\"}")
    @Default.InstanceFactory(value=AzureUserCredentialsFactory.class)
    public @UnknownKeyFor @NonNull @Initialized TokenCredential getAzureCredentialsProvider();

    public void setAzureCredentialsProvider(@UnknownKeyFor @NonNull @Initialized TokenCredential var1);

    public static class AzureUserCredentialsFactory
    implements DefaultValueFactory<TokenCredential> {
        public @UnknownKeyFor @NonNull @Initialized TokenCredential create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return new DefaultAzureCredentialBuilder().build();
        }
    }
}

