/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.shared.Usage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ChatCompletionResponse {
    private final String id;
    private final Integer created;
    private final String model;
    private final List<ChatCompletionChoice> choices;
    private final Usage usage;
    private final String systemFingerprint;

    private ChatCompletionResponse(Builder builder) {
        this.id = builder.id;
        this.created = builder.created;
        this.model = builder.model;
        this.choices = builder.choices;
        this.usage = builder.usage;
        this.systemFingerprint = builder.systemFingerprint;
    }

    public String id() {
        return this.id;
    }

    public Integer created() {
        return this.created;
    }

    public String model() {
        return this.model;
    }

    public List<ChatCompletionChoice> choices() {
        return this.choices;
    }

    public Usage usage() {
        return this.usage;
    }

    public String systemFingerprint() {
        return this.systemFingerprint;
    }

    public String content() {
        return this.choices().get(0).message().content();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatCompletionResponse && this.equalTo((ChatCompletionResponse)another);
    }

    private boolean equalTo(ChatCompletionResponse another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.created, another.created) && Objects.equals(this.model, another.model) && Objects.equals(this.choices, another.choices) && Objects.equals(this.usage, another.usage) && Objects.equals(this.systemFingerprint, another.systemFingerprint);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.created);
        h += (h << 5) + Objects.hashCode(this.model);
        h += (h << 5) + Objects.hashCode(this.choices);
        h += (h << 5) + Objects.hashCode(this.usage);
        h += (h << 5) + Objects.hashCode(this.systemFingerprint);
        return h;
    }

    public String toString() {
        return "ChatCompletionResponse{id=" + this.id + ", created=" + this.created + ", model=" + this.model + ", choices=" + this.choices + ", usage=" + this.usage + ", systemFingerprint=" + this.systemFingerprint + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer created;
        private String model;
        private List<ChatCompletionChoice> choices;
        private Usage usage;
        private String systemFingerprint;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder created(Integer created) {
            this.created = created;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder choices(List<ChatCompletionChoice> choices) {
            if (choices != null) {
                this.choices = Collections.unmodifiableList(choices);
            }
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder systemFingerprint(String systemFingerprint) {
            this.systemFingerprint = systemFingerprint;
            return this;
        }

        public ChatCompletionResponse build() {
            return new ChatCompletionResponse(this);
        }
    }
}

