/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import org.apache.beam.sdk.io.gcp.healthcare.HL7v2ReadParameter;

final class AutoValue_HL7v2ReadParameter
extends HL7v2ReadParameter {
    private final String metadata;
    private final String hl7v2MessageId;

    private AutoValue_HL7v2ReadParameter(String metadata, String hl7v2MessageId) {
        this.metadata = metadata;
        this.hl7v2MessageId = hl7v2MessageId;
    }

    @Override
    public String getMetadata() {
        return this.metadata;
    }

    @Override
    public String getHl7v2MessageId() {
        return this.hl7v2MessageId;
    }

    public String toString() {
        return "HL7v2ReadParameter{metadata=" + this.metadata + ", hl7v2MessageId=" + this.hl7v2MessageId + "}";
    }

    static final class Builder
    extends HL7v2ReadParameter.Builder {
        private String metadata;
        private String hl7v2MessageId;

        Builder() {
        }

        @Override
        HL7v2ReadParameter.Builder setMetadata(String metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public HL7v2ReadParameter.Builder setHl7v2MessageId(String hl7v2MessageId) {
            if (hl7v2MessageId == null) {
                throw new NullPointerException("Null hl7v2MessageId");
            }
            this.hl7v2MessageId = hl7v2MessageId;
            return this;
        }

        @Override
        HL7v2ReadParameter build() {
            if (this.metadata == null || this.hl7v2MessageId == null) {
                StringBuilder missing = new StringBuilder();
                if (this.metadata == null) {
                    missing.append(" metadata");
                }
                if (this.hl7v2MessageId == null) {
                    missing.append(" hl7v2MessageId");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_HL7v2ReadParameter(this.metadata, this.hl7v2MessageId);
        }
    }
}

