/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rest;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rest.Rest;
import org.apache.hop.pipeline.transforms.rest.RestData;
import org.apache.hop.pipeline.transforms.rest.fields.HeaderField;
import org.apache.hop.pipeline.transforms.rest.fields.MatrixParameterField;
import org.apache.hop.pipeline.transforms.rest.fields.ParameterField;
import org.apache.hop.pipeline.transforms.rest.fields.ResultField;

@Transform(id="Rest", image="rest.svg", name="i18n::Rest.Name", description="i18n::Rest.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::RestMeta.keyword"}, documentationUrl="/pipeline/transforms/rest.html")
public class RestMeta
extends BaseTransformMeta<Rest, RestData> {
    private static final Class<?> PKG = RestMeta.class;
    public static final String APPLICATION_TYPE_TEXT_PLAIN = "TEXT PLAIN";
    public static final String APPLICATION_TYPE_XML = "XML";
    public static final String APPLICATION_TYPE_JSON = "JSON";
    public static final String APPLICATION_TYPE_OCTET_STREAM = "OCTET STREAM";
    public static final String APPLICATION_TYPE_XHTML = "XHTML";
    public static final String APPLICATION_TYPE_FORM_URLENCODED = "FORM URLENCODED";
    public static final String APPLICATION_TYPE_ATOM_XML = "ATOM XML";
    public static final String APPLICATION_TYPE_SVG_XML = "SVG XML";
    public static final String APPLICATION_TYPE_TEXT_XML = "TEXT XML";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_PUT = "PUT";
    public static final String HTTP_METHOD_DELETE = "DELETE";
    public static final String HTTP_METHOD_HEAD = "HEAD";
    public static final String HTTP_METHOD_OPTIONS = "OPTIONS";
    public static final String HTTP_METHOD_PATCH = "PATCH";
    public static final String[] APPLICATION_TYPES = new String[]{"TEXT PLAIN", "XML", "JSON", "OCTET STREAM", "XHTML", "FORM URLENCODED", "ATOM XML", "SVG XML", "TEXT XML"};
    @HopMetadataProperty(key="applicationType", injectionKey="APPLICATION_TYPE")
    private String applicationType;
    public static final String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "PATCH"};
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_READ_TIMEOUT = 10000;
    @HopMetadataProperty(key="connection_name", injectionKey="CONNECTION_NAME")
    private String connectionName;
    @HopMetadataProperty(key="url", injectionKey="URL")
    private String url;
    @HopMetadataProperty(key="urlInField", injectionKey="URL_IN_FIELD")
    private boolean urlInField;
    @HopMetadataProperty(key="urlField", injectionKey="URL_IN_FIELD")
    private String urlField;
    @HopMetadataProperty(key="proxyHost", injectionKey="PROXY_HOST")
    private String proxyHost;
    @HopMetadataProperty(key="proxyPort", injectionKey="PROXY_PORT")
    private String proxyPort;
    @HopMetadataProperty(key="httpLogin", injectionKey="HTTP_LOGIN")
    private String httpLogin;
    @HopMetadataProperty(key="httpPassword", injectionKey="HTTP_PASSWORD")
    private String httpPassword;
    @HopMetadataProperty(key="preemptive", injectionKey="PREEMPTIVE")
    private boolean preemptive;
    @HopMetadataProperty(key="bodyField", injectionKey="BODY_FIELD")
    private String bodyField;
    @HopMetadataProperty(key="method", injectionKey="METHOD")
    private String method;
    @HopMetadataProperty(key="dynamicMethod", injectionKey="DYMAMIC_METHOD")
    private boolean dynamicMethod;
    @HopMetadataProperty(key="methodFieldName", injectionKey="METHOD_FIELD_NAME")
    private String methodFieldName;
    @HopMetadataProperty(key="trustStoreFile", injectionKey="TRUSTSTORE_FILE")
    private String trustStoreFile;
    @HopMetadataProperty(key="trustStorePassword", injectionKey="TRUSTSTORE_PASSWORD", password=true)
    private String trustStorePassword;
    @HopMetadataProperty(key="connectionTimeout", injectionKey="CONNECTION_TIMEOUT")
    private String connectionTimeout;
    @HopMetadataProperty(key="readTimeout", injectionKey="READ_TIMEOUT")
    private String readTimeout;
    @HopMetadataProperty(key="ignoreSsl", injectionKey="IGNORE_SSL")
    private boolean ignoreSsl;
    @HopMetadataProperty(key="header", groupKey="headers", injectionKey="HEADERS", injectionGroupKey="HEADER")
    private List<HeaderField> headerFields = new ArrayList<HeaderField>();
    @HopMetadataProperty(key="parameter", injectionKey="PARAMETER", groupKey="parameters", injectionGroupKey="PARAMETERS")
    private List<ParameterField> parameterFields = new ArrayList<ParameterField>();
    @HopMetadataProperty(key="matrixParameter", injectionKey="MATRIX_PARAMETER", groupKey="matrixParameters", injectionGroupKey="MATRIX_PARAMETERS")
    private List<MatrixParameterField> matrixParameterFields = new ArrayList<MatrixParameterField>();
    @HopMetadataProperty(key="result", injectionKey="RESULT")
    private ResultField resultField = new ResultField();

    public Object clone() {
        RestMeta retval = (RestMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.headerFields = new ArrayList<HeaderField>();
        this.parameterFields = new ArrayList<ParameterField>();
        this.matrixParameterFields = new ArrayList<MatrixParameterField>();
        this.resultField = new ResultField();
        this.method = HTTP_METHOD_GET;
        this.dynamicMethod = false;
        this.methodFieldName = null;
        this.preemptive = false;
        this.trustStoreFile = null;
        this.trustStorePassword = null;
        this.applicationType = APPLICATION_TYPE_TEXT_PLAIN;
        this.readTimeout = String.valueOf(10000);
        this.connectionTimeout = String.valueOf(10000);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        String headerFieldName;
        ValueMetaString v;
        if (!Utils.isEmpty((CharSequence)this.resultField.getFieldName())) {
            v = new ValueMetaString(variables.resolve(this.resultField.getFieldName()));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.resultField.getCode())) {
            v = new ValueMetaInteger(variables.resolve(this.resultField.getCode()));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.resultField.getResponseTime())) {
            v = new ValueMetaInteger(variables.resolve(this.resultField.getResponseTime()));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(headerFieldName = variables.resolve(this.resultField.getResponseHeader())))) {
            ValueMetaString v2 = new ValueMetaString(headerFieldName);
            v2.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v2);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = this.urlInField ? (Utils.isEmpty((CharSequence)this.urlField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlfieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlfieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta)) : (Utils.isEmpty((CharSequence)this.url) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlOk", (String[])new String[0]), (ICheckResultSource)transformMeta));
        remarks.add((ICheckResult)cr);
        cr = this.dynamicMethod ? (Utils.isEmpty((CharSequence)this.methodFieldName) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodFieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta)) : (Utils.isEmpty((CharSequence)this.method) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodOk", (String[])new String[0]), (ICheckResultSource)transformMeta));
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static boolean isActiveBody(String method) {
        if (Utils.isEmpty((CharSequence)method)) {
            return false;
        }
        return method.equals(HTTP_METHOD_POST) || method.equals(HTTP_METHOD_PUT) || method.equals(HTTP_METHOD_PATCH) || method.equals(HTTP_METHOD_DELETE);
    }

    public static boolean isActiveParameters(String method) {
        if (Utils.isEmpty((CharSequence)method)) {
            return false;
        }
        return method.equals(HTTP_METHOD_GET) || method.equals(HTTP_METHOD_POST) || method.equals(HTTP_METHOD_PUT) || method.equals(HTTP_METHOD_PATCH) || method.equals(HTTP_METHOD_DELETE);
    }

    @Generated
    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    @Generated
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUrlInField(boolean urlInField) {
        this.urlInField = urlInField;
    }

    @Generated
    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Generated
    public void setHttpLogin(String httpLogin) {
        this.httpLogin = httpLogin;
    }

    @Generated
    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    @Generated
    public void setPreemptive(boolean preemptive) {
        this.preemptive = preemptive;
    }

    @Generated
    public void setBodyField(String bodyField) {
        this.bodyField = bodyField;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setDynamicMethod(boolean dynamicMethod) {
        this.dynamicMethod = dynamicMethod;
    }

    @Generated
    public void setMethodFieldName(String methodFieldName) {
        this.methodFieldName = methodFieldName;
    }

    @Generated
    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    @Generated
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Generated
    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setReadTimeout(String readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Generated
    public void setIgnoreSsl(boolean ignoreSsl) {
        this.ignoreSsl = ignoreSsl;
    }

    @Generated
    public void setHeaderFields(List<HeaderField> headerFields) {
        this.headerFields = headerFields;
    }

    @Generated
    public void setParameterFields(List<ParameterField> parameterFields) {
        this.parameterFields = parameterFields;
    }

    @Generated
    public void setMatrixParameterFields(List<MatrixParameterField> matrixParameterFields) {
        this.matrixParameterFields = matrixParameterFields;
    }

    @Generated
    public void setResultField(ResultField resultField) {
        this.resultField = resultField;
    }

    @Generated
    public String getApplicationType() {
        return this.applicationType;
    }

    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public boolean isUrlInField() {
        return this.urlInField;
    }

    @Generated
    public String getUrlField() {
        return this.urlField;
    }

    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Generated
    public String getProxyPort() {
        return this.proxyPort;
    }

    @Generated
    public String getHttpLogin() {
        return this.httpLogin;
    }

    @Generated
    public String getHttpPassword() {
        return this.httpPassword;
    }

    @Generated
    public boolean isPreemptive() {
        return this.preemptive;
    }

    @Generated
    public String getBodyField() {
        return this.bodyField;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public boolean isDynamicMethod() {
        return this.dynamicMethod;
    }

    @Generated
    public String getMethodFieldName() {
        return this.methodFieldName;
    }

    @Generated
    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    @Generated
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Generated
    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public String getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public boolean isIgnoreSsl() {
        return this.ignoreSsl;
    }

    @Generated
    public List<HeaderField> getHeaderFields() {
        return this.headerFields;
    }

    @Generated
    public List<ParameterField> getParameterFields() {
        return this.parameterFields;
    }

    @Generated
    public List<MatrixParameterField> getMatrixParameterFields() {
        return this.matrixParameterFields;
    }

    @Generated
    public ResultField getResultField() {
        return this.resultField;
    }
}

