/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.creditcardvalidator;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.creditcardvalidator.CreditCardValidator;
import org.apache.hop.pipeline.transforms.creditcardvalidator.CreditCardValidatorData;

@Transform(id="CreditCardValidator", image="creditcardvalidator.svg", name="i18n::CreditCardValidator.Name", description="i18n::CreditCardValidator.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Validation", keywords={"i18n::CreditCardValidatorMeta.keyword"}, documentationUrl="/pipeline/transforms/creditcardvalidator.html")
public class CreditCardValidatorMeta
extends BaseTransformMeta<CreditCardValidator, CreditCardValidatorData> {
    private static final Class<?> PKG = CreditCardValidatorMeta.class;
    @HopMetadataProperty(key="fieldname")
    private String fieldName;
    @HopMetadataProperty(key="cardtype")
    private String cardType;
    @HopMetadataProperty(key="notvalidmsg")
    private String notValidMessage;
    @HopMetadataProperty(key="resultfieldname")
    private String resultFieldName;
    @HopMetadataProperty(key="onlydigits")
    private boolean onlyDigits;

    public CreditCardValidatorMeta() {
    }

    public CreditCardValidatorMeta(CreditCardValidatorMeta m) {
        this.fieldName = m.fieldName;
        this.cardType = m.cardType;
        this.notValidMessage = m.notValidMessage;
        this.resultFieldName = m.resultFieldName;
        this.onlyDigits = m.onlyDigits;
    }

    public CreditCardValidatorMeta clone() {
        return new CreditCardValidatorMeta(this);
    }

    public void setDefault() {
        this.resultFieldName = "result";
        this.onlyDigits = false;
        this.cardType = "card type";
        this.notValidMessage = "not valid message";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String realCardType;
        String realResultFieldName = variables.resolve(this.resultFieldName);
        if (!Utils.isEmpty((CharSequence)realResultFieldName)) {
            ValueMetaBoolean v = new ValueMetaBoolean(realResultFieldName);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(realCardType = variables.resolve(this.cardType)))) {
            ValueMetaString v = new ValueMetaString(realCardType);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        String realNotValidMessage = variables.resolve(this.notValidMessage);
        if (!Utils.isEmpty((CharSequence)this.notValidMessage)) {
            ValueMetaString v = new ValueMetaString(realNotValidMessage);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        String realresultfieldname = variables.resolve(this.resultFieldName);
        if (Utils.isEmpty((CharSequence)realresultfieldname)) {
            errorMessage = BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.fieldName)) {
            errorMessage = BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.CardFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.CardFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getCardType() {
        return this.cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getNotValidMessage() {
        return this.notValidMessage;
    }

    public void setNotValidMessage(String notValidMessage) {
        this.notValidMessage = notValidMessage;
    }

    public String getResultFieldName() {
        return this.resultFieldName;
    }

    public void setResultFieldName(String resultFieldName) {
        this.resultFieldName = resultFieldName;
    }

    public boolean isOnlyDigits() {
        return this.onlyDigits;
    }

    public void setOnlyDigits(boolean onlyDigits) {
        this.onlyDigits = onlyDigits;
    }
}

