/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeaderElement;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHeaderElement {
    TestHeaderElement() {
    }

    @Test
    void testConstructor3() {
        BasicHeaderElement element = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", "value2")});
        Assertions.assertEquals((Object)"name", (Object)element.getName());
        Assertions.assertEquals((Object)"value", (Object)element.getValue());
        Assertions.assertEquals((int)2, (int)element.getParameters().length);
        Assertions.assertEquals((Object)"value1", (Object)element.getParameterByName("param1").getValue());
        Assertions.assertEquals((Object)"value2", (Object)element.getParameterByName("param2").getValue());
    }

    @Test
    void testConstructor2() {
        BasicHeaderElement element = new BasicHeaderElement("name", "value");
        Assertions.assertEquals((Object)"name", (Object)element.getName());
        Assertions.assertEquals((Object)"value", (Object)element.getValue());
        Assertions.assertEquals((int)0, (int)element.getParameters().length);
    }

    @Test
    void testInvalidName() {
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHeaderElement(null, null, (NameValuePair[])null));
    }

    @Test
    void testParamByName() {
        String s = "name = value; param1 = value1; param2 = value2";
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append("name = value; param1 = value1; param2 = value2");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        HeaderElement element = BasicHeaderValueParser.INSTANCE.parseHeaderElement((CharSequence)buf, cursor);
        Assertions.assertEquals((Object)"value1", (Object)element.getParameterByName("param1").getValue());
        Assertions.assertEquals((Object)"value2", (Object)element.getParameterByName("param2").getValue());
        Assertions.assertNull((Object)element.getParameterByName("param3"));
        Assertions.assertThrows(NullPointerException.class, () -> element.getParameterByName(null));
    }

    @Test
    void testToString() {
        BasicHeaderElement element = new BasicHeaderElement("name", "value", new NameValuePair[]{new BasicNameValuePair("param1", "value1"), new BasicNameValuePair("param2", "value2")});
        Assertions.assertEquals((Object)"name=value; param1=value1; param2=value2", (Object)element.toString());
    }
}

