/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.calcite.CalciteQueryEngineConfiguration;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsProcessor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryProperties;
import org.apache.ignite.internal.processors.query.calcite.CalciteQueryProcessor;
import org.apache.ignite.internal.processors.query.calcite.Query;
import org.apache.ignite.internal.processors.query.calcite.QueryRegistry;
import org.apache.ignite.internal.processors.query.calcite.QueryState;
import org.apache.ignite.internal.processors.query.calcite.RootQuery;
import org.apache.ignite.internal.processors.query.calcite.RunningFragment;
import org.apache.ignite.internal.processors.query.calcite.exec.ClosableIteratorsHolder;
import org.apache.ignite.internal.processors.query.calcite.exec.ExchangeService;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionService;
import org.apache.ignite.internal.processors.query.calcite.exec.LogicalRelImplementor;
import org.apache.ignite.internal.processors.query.calcite.exec.MailboxRegistry;
import org.apache.ignite.internal.processors.query.calcite.exec.QueryTaskExecutor;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.ddl.DdlCommandHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Outbox;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.GlobalMemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.IoTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.MemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.NoOpIoTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.NoOpMemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.PerformanceStatisticsIoTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.QueryMemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.externalize.RelJsonReader;
import org.apache.ignite.internal.processors.query.calcite.message.ErrorMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MessageService;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.processors.query.calcite.message.QueryStartRequest;
import org.apache.ignite.internal.processors.query.calcite.message.QueryStartResponse;
import org.apache.ignite.internal.processors.query.calcite.metadata.AffinityService;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentDescription;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMapping;
import org.apache.ignite.internal.processors.query.calcite.metadata.MappingService;
import org.apache.ignite.internal.processors.query.calcite.metadata.RemoteException;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.CacheKey;
import org.apache.ignite.internal.processors.query.calcite.prepare.DdlPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.ExecutionPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.ExplainPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.FieldsMetadataImpl;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.prepare.FragmentPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.MultiStepPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.PrepareServiceImpl;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlanCache;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.CreateTableCommand;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexBound;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexCount;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableModify;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableScan;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.schema.SchemaHolder;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.ConvertingClosableIterator;
import org.apache.ignite.internal.processors.query.calcite.util.ListFieldsQueryCursor;
import org.apache.ignite.internal.processors.query.running.HeavyQueriesTracker;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ExecutionServiceImpl<Row>
extends AbstractService
implements ExecutionService<Row> {
    private final DiscoveryEventListener discoLsnr;
    private UUID locNodeId;
    private GridKernalContext ctx;
    private GridEventStorageManager evtMgr;
    private GridCachePartitionExchangeManager<?, ?> exchangeMgr;
    private CacheObjectValueContext objValCtx;
    private QueryPlanCache qryPlanCache;
    private SchemaHolder schemaHolder;
    private QueryTaskExecutor taskExecutor;
    private FailureProcessor failureProcessor;
    private PerformanceStatisticsProcessor perfStatProc;
    private AffinityService partSvc;
    private MailboxRegistry mailboxRegistry;
    private MappingService mappingSvc;
    private MessageService msgSvc;
    private ExchangeService exchangeSvc;
    private PrepareServiceImpl prepareSvc;
    private ClosableIteratorsHolder iteratorsHolder;
    private QueryRegistry qryReg;
    private final RowHandler<Row> handler;
    private DdlCommandHandler ddlCmdHnd;
    private CalciteQueryEngineConfiguration cfg;
    private FrameworkConfig frameworkCfg;
    private MemoryTracker memoryTracker;

    public ExecutionServiceImpl(GridKernalContext ctx, RowHandler<Row> handler) {
        super(ctx);
        this.handler = handler;
        this.discoLsnr = (e, c) -> this.onNodeLeft(e.eventNode().id());
    }

    public void localNodeId(UUID locNodeId) {
        this.locNodeId = locNodeId;
    }

    public UUID localNodeId() {
        return this.locNodeId;
    }

    public void queryPlanCache(QueryPlanCache qryPlanCache) {
        this.qryPlanCache = qryPlanCache;
    }

    public QueryPlanCache queryPlanCache() {
        return this.qryPlanCache;
    }

    public void schemaHolder(SchemaHolder schemaHolder) {
        this.schemaHolder = schemaHolder;
    }

    public SchemaHolder schemaHolder() {
        return this.schemaHolder;
    }

    public void taskExecutor(QueryTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public QueryTaskExecutor taskExecutor() {
        return this.taskExecutor;
    }

    public void failureProcessor(FailureProcessor failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    public FailureProcessor failureProcessor() {
        return this.failureProcessor;
    }

    public void performanceStatisticsProcessor(PerformanceStatisticsProcessor perfStatProc) {
        this.perfStatProc = perfStatProc;
    }

    public void partitionService(AffinityService partSvc) {
        this.partSvc = partSvc;
    }

    public AffinityService partitionService() {
        return this.partSvc;
    }

    public void mailboxRegistry(MailboxRegistry mailboxRegistry) {
        this.mailboxRegistry = mailboxRegistry;
    }

    public MailboxRegistry mailboxRegistry() {
        return this.mailboxRegistry;
    }

    public void mappingService(MappingService mappingSvc) {
        this.mappingSvc = mappingSvc;
    }

    public MappingService mappingService() {
        return this.mappingSvc;
    }

    public void messageService(MessageService msgSvc) {
        this.msgSvc = msgSvc;
    }

    public MessageService messageService() {
        return this.msgSvc;
    }

    public void exchangeService(ExchangeService exchangeSvc) {
        this.exchangeSvc = exchangeSvc;
    }

    public void prepareService(PrepareServiceImpl prepareSvc) {
        this.prepareSvc = prepareSvc;
    }

    public ExchangeService exchangeService() {
        return this.exchangeSvc;
    }

    public void eventManager(GridEventStorageManager evtMgr) {
        this.evtMgr = evtMgr;
    }

    public GridEventStorageManager eventManager() {
        return this.evtMgr;
    }

    public void exchangeManager(GridCachePartitionExchangeManager<?, ?> exchangeMgr) {
        this.exchangeMgr = exchangeMgr;
    }

    public void cacheObjectValueContext(CacheObjectValueContext objValCtx) {
        this.objValCtx = objValCtx;
    }

    public GridCachePartitionExchangeManager<?, ?> exchangeManager() {
        return this.exchangeMgr;
    }

    public void iteratorsHolder(ClosableIteratorsHolder iteratorsHolder) {
        this.iteratorsHolder = iteratorsHolder;
    }

    public ClosableIteratorsHolder iteratorsHolder() {
        return this.iteratorsHolder;
    }

    public void queryRegistry(QueryRegistry qryReg) {
        this.qryReg = qryReg;
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    @Override
    public void onStart(GridKernalContext ctx) {
        this.ctx = ctx;
        this.localNodeId(ctx.localNodeId());
        this.exchangeManager(ctx.cache().context().exchange());
        this.cacheObjectValueContext((CacheObjectValueContext)ctx.query().objectContext());
        this.eventManager(ctx.event());
        this.performanceStatisticsProcessor(ctx.performanceStatistics());
        this.iteratorsHolder(new ClosableIteratorsHolder(this.log));
        CalciteQueryProcessor proc = Objects.requireNonNull(Commons.lookupComponent(ctx, CalciteQueryProcessor.class));
        this.queryPlanCache(proc.queryPlanCache());
        this.schemaHolder(proc.schemaHolder());
        this.taskExecutor(proc.taskExecutor());
        this.failureProcessor(proc.failureProcessor());
        this.partitionService(proc.affinityService());
        this.mailboxRegistry(proc.mailboxRegistry());
        this.mappingService(proc.mappingService());
        this.messageService(proc.messageService());
        this.exchangeService(proc.exchangeService());
        this.queryRegistry(proc.queryRegistry());
        this.prepareService(proc.prepareService());
        this.ddlCmdHnd = new DdlCommandHandler(ctx.query(), ctx.cache(), ctx.security(), () -> this.schemaHolder().schema(null));
        this.cfg = proc.config();
        this.frameworkCfg = proc.frameworkConfig();
        this.memoryTracker = this.cfg.getGlobalMemoryQuota() > 0L ? new GlobalMemoryTracker(this.cfg.getGlobalMemoryQuota()) : NoOpMemoryTracker.INSTANCE;
        this.init();
    }

    @Override
    public void init() {
        this.messageService().register((n, m) -> this.onMessage(n, (QueryStartRequest)m), MessageType.QUERY_START_REQUEST);
        this.messageService().register((n, m) -> this.onMessage(n, (QueryStartResponse)m), MessageType.QUERY_START_RESPONSE);
        this.messageService().register((n, m) -> this.onMessage(n, (ErrorMessage)m), MessageType.QUERY_ERROR_MESSAGE);
        this.eventManager().addDiscoveryEventListener(this.discoLsnr, 12, new int[]{11});
        this.iteratorsHolder().init();
    }

    @Override
    public void tearDown() {
        this.eventManager().removeDiscoveryEventListener(this.discoLsnr, new int[]{12, 11});
        this.iteratorsHolder().tearDown();
    }

    protected AffinityTopologyVersion topologyVersion() {
        return this.exchangeManager().readyAffinityVersion();
    }

    private BaseQueryContext createQueryContext(Context parent, @Nullable String schema) {
        return BaseQueryContext.builder().parentContext(parent).frameworkConfig(this.frameworkCfg).defaultSchema(this.schemaHolder().schema(schema)).logger(this.log).build();
    }

    private QueryPlan prepareFragment(BaseQueryContext ctx, String jsonFragment) {
        return new FragmentPlan(jsonFragment, (IgniteRel)RelJsonReader.fromJson(ctx, jsonFragment));
    }

    @Override
    public FieldsQueryCursor<List<?>> executePlan(RootQuery<Row> qry, QueryPlan plan) {
        switch (plan.type()) {
            case DML: {
                ListFieldsQueryCursor<?> cur = this.mapAndExecutePlan(qry, (MultiStepPlan)plan);
                cur.iterator().hasNext();
                return cur;
            }
            case QUERY: {
                return this.mapAndExecutePlan(qry, (MultiStepPlan)plan);
            }
            case EXPLAIN: {
                return this.executeExplain(qry, (ExplainPlan)plan);
            }
            case DDL: {
                return this.executeDdl(qry, (DdlPlan)plan);
            }
        }
        throw new AssertionError((Object)("Unexpected plan type: " + plan));
    }

    private FieldsQueryCursor<List<?>> executeDdl(RootQuery<Row> qry, DdlPlan plan) {
        try {
            this.ddlCmdHnd.handle(qry.id(), plan.command());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSQLException("Failed to execute DDL statement [stmt=" + qry.sql() + ", err=" + e.getMessage() + "]", (Throwable)e);
        }
        if (plan.command() instanceof CreateTableCommand && ((CreateTableCommand)plan.command()).insertStatement() != null) {
            RootQuery<Row> insQry = qry.childQuery(this.schemaHolder.schema(qry.context().schemaName()));
            this.qryReg.register(insQry);
            SqlInsert insertStmt = ((CreateTableCommand)plan.command()).insertStatement();
            QueryPlan dmlPlan = this.prepareSvc.prepareSingle((SqlNode)insertStmt, insQry.planningContext());
            return this.executePlan(insQry, dmlPlan);
        }
        QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(0L)), null, false, false);
        IgniteTypeFactory typeFactory = qry.context().typeFactory();
        resCur.fieldsMeta(new FieldsMetadataImpl(RelOptUtil.createDmlRowType((SqlKind)SqlKind.INSERT, (RelDataTypeFactory)typeFactory), null, null).queryFieldsMetadata(typeFactory));
        return resCur;
    }

    private ListFieldsQueryCursor<?> mapAndExecutePlan(RootQuery<Row> qry, MultiStepPlan plan) {
        Function<List<Object>, List<Object>> rowConverter;
        QueryProperties qryProps;
        long timeout;
        qry.mapping();
        Map<String, Object> qryParams = Commons.parametersMap(qry.parameters());
        MappingQueryContext mapCtx = Commons.mapContext(this.locNodeId, this.topologyVersion(), qry.context(), qryParams);
        ExecutionPlan execPlan = plan.init(this.mappingSvc, this.partSvc, mapCtx);
        List<Fragment> fragments = execPlan.fragments();
        if (this.ctx.security().enabled()) {
            for (Fragment fragment : fragments) {
                this.checkPermissions(fragment.root());
            }
        }
        Fragment fragment = (Fragment)F.first(fragments);
        if (U.assertionsEnabled()) {
            assert (fragment != null);
            FragmentMapping mapping = execPlan.mapping(fragment);
            assert (mapping != null);
            List<UUID> nodes = mapping.nodeIds();
            assert (nodes != null && (nodes.size() == 1 && ((UUID)F.first(nodes)).equals(this.localNodeId()) || nodes.isEmpty())) : "nodes=" + nodes + ", localNode=" + this.localNodeId();
        }
        if ((timeout = qry.remainingTime()) == 0L) {
            throw new IgniteSQLException("The query was cancelled due to timeout", 3014, (Throwable)new QueryCancelledException());
        }
        FragmentDescription fragmentDesc = new FragmentDescription(fragment.fragmentId(), execPlan.mapping(fragment), execPlan.target(fragment), execPlan.remotes(fragment));
        MemoryTracker qryMemoryTracker = qry.createMemoryTracker(this.memoryTracker, this.cfg.getQueryMemoryQuota());
        GridNearTxLocal userTx = (GridNearTxLocal)Commons.queryTransaction(qry.context(), this.ctx.cache().context());
        ExecutionContext<Row> ectx = new ExecutionContext<Row>(qry.context(), this.taskExecutor(), qry.id(), this.locNodeId, this.locNodeId, mapCtx.topologyVersion(), fragmentDesc, this.handler, qryMemoryTracker, this.createIoTracker(this.locNodeId, qry.localQueryId()), timeout, qryParams, userTx == null ? null : ExecutionContext.transactionChanges(userTx.writeEntries()));
        Object node = new LogicalRelImplementor<Row>(ectx, this.partitionService(), this.mailboxRegistry(), this.exchangeService(), this.failureProcessor()).go(fragment.root());
        qry.run(ectx, execPlan, plan.fieldsMetadata(), (Node<Row>)node);
        Map fragmentsPerNode = fragments.stream().skip(1L).flatMap(f -> f.mapping().nodeIds().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        for (int i = 1; i < fragments.size(); ++i) {
            fragment = fragments.get(i);
            fragmentDesc = new FragmentDescription(fragment.fragmentId(), execPlan.mapping(fragment), execPlan.target(fragment), execPlan.remotes(fragment));
            Throwable ex = null;
            byte[] parametersMarshalled = null;
            for (UUID nodeId : fragmentDesc.nodeIds()) {
                if (ex != null) {
                    qry.onResponse(nodeId, fragment.fragmentId(), ex);
                    continue;
                }
                try {
                    QueryStartRequest req = new QueryStartRequest(qry.id(), qry.localQueryId(), qry.context().schemaName(), fragment.serialized(), ectx.topologyVersion(), fragmentDesc, fragmentsPerNode.get(nodeId).intValue(), qry.parameters(), parametersMarshalled, timeout, ectx.getQryTxEntries());
                    this.messageService().send(nodeId, req);
                    if (parametersMarshalled != null) continue;
                    parametersMarshalled = req.parametersMarshalled();
                }
                catch (Throwable e) {
                    ex = e;
                    qry.onResponse(nodeId, fragment.fragmentId(), ex);
                }
            }
        }
        if (this.perfStatProc.enabled()) {
            this.perfStatProc.queryProperty(GridCacheQueryType.SQL_FIELDS, qry.initiatorNodeId(), qry.localQueryId(), "Query plan", plan.textPlan());
        }
        Function<Object, Object> fieldConverter = (qryProps = qry.context().unwrap(QueryProperties.class)) == null || qryProps.keepBinary() ? null : o -> CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)this.objValCtx, (Object)o, (boolean)false, (boolean)true, null);
        HeavyQueriesTracker.ResultSetChecker resultSetChecker = this.ctx.query().runningQueryManager().heavyQueriesTracker().resultSetChecker(qry);
        if (qryProps != null && qryProps.cacheName() != null && this.evtMgr.isRecordable(97)) {
            ClusterNode locNode = this.ctx.discovery().localNode();
            UUID subjId = SecurityUtils.securitySubjectId((GridKernalContext)this.ctx);
            rowConverter = row -> {
                this.evtMgr.record((Event)new CacheQueryReadEvent(locNode, "SQL fields query result set row read.", 97, CacheQueryType.SQL_FIELDS.name(), qryProps.cacheName(), null, qry.sql(), null, null, qry.parameters(), subjId, null, null, null, null, row));
                resultSetChecker.checkOnFetchNext();
                return row;
            };
        } else {
            rowConverter = row -> {
                resultSetChecker.checkOnFetchNext();
                return row;
            };
        }
        Runnable onClose = () -> {
            if (this.perfStatProc.enabled()) {
                this.perfStatProc.queryRowsProcessed(GridCacheQueryType.SQL_FIELDS, qry.initiatorNodeId(), qry.localQueryId(), "Fetched", resultSetChecker.fetchedSize());
            }
            resultSetChecker.checkOnClose();
        };
        ConvertingClosableIterator<Row> it = new ConvertingClosableIterator<Row>(this.iteratorsHolder().iterator(qry.iterator()), ectx, fieldConverter, rowConverter, onClose);
        MemoryTracker curMemoryTracker = QueryMemoryTracker.create(qryMemoryTracker, this.cfg.getQueryMemoryQuota());
        return new ListFieldsQueryCursor<Row>(plan, it, ectx, curMemoryTracker);
    }

    private void checkPermissions(IgniteRel root) {
        IgniteRelShuttle shuttle = new IgniteRelShuttle(){

            @Override
            public IgniteRel visit(IgniteTableModify rel) {
                return this.authorize(rel, rel.getOperation() == TableModify.Operation.DELETE ? IgniteTable.Operation.REMOVE : IgniteTable.Operation.PUT);
            }

            @Override
            public IgniteRel visit(IgniteTableScan rel) {
                return this.authorize(rel, IgniteTable.Operation.READ);
            }

            @Override
            public IgniteRel visit(IgniteIndexScan rel) {
                return this.authorize(rel, IgniteTable.Operation.READ);
            }

            @Override
            public IgniteRel visit(IgniteIndexCount rel) {
                return this.authorize(rel, IgniteTable.Operation.READ);
            }

            @Override
            public IgniteRel visit(IgniteIndexBound rel) {
                return this.authorize(rel, IgniteTable.Operation.READ);
            }

            private IgniteRel authorize(IgniteRel rel, IgniteTable.Operation op) {
                ((IgniteTable)rel.getTable().unwrap(IgniteTable.class)).authorize(op);
                return rel;
            }
        };
        shuttle.visit(root);
    }

    private FieldsQueryCursor<List<?>> executeExplain(RootQuery<Row> qry, ExplainPlan plan) {
        QueryCursorImpl cur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(plan.plan())));
        cur.fieldsMeta(plan.fieldsMeta().queryFieldsMetadata(Commons.typeFactory()));
        return cur;
    }

    private void executeFragment(Query<Row> qry, FragmentPlan plan, ExecutionContext<Row> ectx) {
        UUID origNodeId = ectx.originatingNodeId();
        Outbox node = (Outbox)new LogicalRelImplementor<Row>(ectx, this.partitionService(), this.mailboxRegistry(), this.exchangeService(), this.failureProcessor()).go(plan.root());
        qry.addFragment(new RunningFragment<Row>(plan.root(), node, ectx));
        node.init();
        if (!qry.isExchangeWithInitNodeStarted(ectx.fragmentId())) {
            try {
                this.messageService().send(origNodeId, new QueryStartResponse(qry.id(), ectx.fragmentId()));
            }
            catch (IgniteCheckedException e) {
                IgniteException wrpEx = new IgniteException("Failed to send reply. [nodeId=" + origNodeId + "]", (Throwable)e);
                throw wrpEx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessage(UUID nodeId, QueryStartRequest msg) {
        assert (nodeId != null && msg != null);
        try {
            Query<?> qry = this.qryReg.register(new Query(msg.queryId(), nodeId, null, this.exchangeSvc, (q, ex) -> this.qryReg.unregister(q.id(), (Throwable)ex), this.log, msg.totalFragmentsCount()));
            BaseQueryContext qctx = this.createQueryContext(Contexts.empty(), msg.schema());
            QueryPlan qryPlan = this.queryPlanCache().queryPlan(new CacheKey(msg.schema(), msg.root()), () -> this.prepareFragment(qctx, msg.root()));
            assert (qryPlan.type() == QueryPlan.Type.FRAGMENT);
            ExecutionContext<Row> ectx = new ExecutionContext<Row>(qctx, this.taskExecutor(), msg.queryId(), this.locNodeId, nodeId, msg.topologyVersion(), msg.fragmentDescription(), this.handler, qry.createMemoryTracker(this.memoryTracker, this.cfg.getQueryMemoryQuota()), this.createIoTracker(nodeId, msg.originatingQryId()), msg.timeout(), Commons.parametersMap(msg.parameters()), msg.queryTransactionEntries());
            this.executeFragment(qry, (FragmentPlan)qryPlan, ectx);
        }
        catch (Throwable ex2) {
            U.error((IgniteLogger)this.log, (Object)"Failed to start query fragment ", (Throwable)ex2);
            this.mailboxRegistry.outboxes(msg.queryId(), msg.fragmentId(), -1L).forEach(AbstractNode::close);
            this.mailboxRegistry.inboxes(msg.queryId(), msg.fragmentId(), -1L).forEach(AbstractNode::close);
            try {
                this.messageService().send(nodeId, new QueryStartResponse(msg.queryId(), msg.fragmentId(), ex2));
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)("Error occurred during send error message: " + X.getFullStackTrace((Throwable)e)));
            }
            finally {
                this.qryReg.query(msg.queryId()).onError(ex2);
            }
        }
    }

    private void onMessage(UUID nodeId, QueryStartResponse msg) {
        assert (nodeId != null && msg != null);
        Query<?> qry = this.qryReg.query(msg.queryId());
        if (qry != null) {
            assert (qry instanceof RootQuery) : "Unexpected query object: " + qry;
            ((RootQuery)qry).onResponse(nodeId, msg.fragmentId(), msg.error());
        }
    }

    private void onMessage(UUID nodeId, ErrorMessage msg) {
        assert (nodeId != null && msg != null);
        Query<?> qry = this.qryReg.query(msg.queryId());
        if (qry != null && qry.state() != QueryState.CLOSED) {
            assert (qry instanceof RootQuery) : "Unexpected query object: " + qry;
            RemoteException e = new RemoteException(nodeId, msg.queryId(), msg.fragmentId(), msg.error());
            if (X.hasCause((Throwable)msg.error(), (Class[])new Class[]{QueryCancelledException.class})) {
                e = new IgniteSQLException("The query was cancelled while executing.", 3014, (Throwable)e);
            }
            qry.onError(e);
        }
    }

    private void onNodeLeft(UUID nodeId) {
        this.qryReg.runningQueries().forEach(qry -> qry.onNodeLeft(nodeId));
    }

    private IoTracker createIoTracker(UUID originatingNodeId, long originatingQryId) {
        return this.perfStatProc.enabled() ? new PerformanceStatisticsIoTracker(this.perfStatProc, originatingNodeId, originatingQryId) : NoOpIoTracker.INSTANCE;
    }
}

