/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.rocksdb.RocksDbDataRegion;
import org.apache.ignite.internal.storage.rocksdb.RocksDbTableStorage;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbDataRegionConfiguration;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbDataRegionView;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbDataStorageView;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbStorageEngineConfiguration;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteUtils;
import org.rocksdb.RocksDB;

public class RocksDbStorageEngine
implements StorageEngine {
    public static final String ENGINE_NAME = "rocksdb";
    private static final String TABLE_DIR_PREFIX = "table-";
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbStorageEngine.class);
    private final RocksDbStorageEngineConfiguration engineConfig;
    private final Path storagePath;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new NamedThreadFactory("rocksdb-storage-engine-pool", LOG));
    private final ScheduledExecutorService scheduledPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("rocksdb-storage-engine-scheduled-pool", LOG));
    private final Map<String, RocksDbDataRegion> regions = new ConcurrentHashMap<String, RocksDbDataRegion>();

    public RocksDbStorageEngine(RocksDbStorageEngineConfiguration engineConfig, Path storagePath) {
        this.engineConfig = engineConfig;
        this.storagePath = storagePath;
    }

    public RocksDbStorageEngineConfiguration configuration() {
        return this.engineConfig;
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public ScheduledExecutorService scheduledPool() {
        return this.scheduledPool;
    }

    public void start() throws StorageException {
        this.registerDataRegion(this.engineConfig.defaultRegion());
        this.engineConfig.regions().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<RocksDbDataRegionView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<RocksDbDataRegionView> ctx) {
                RocksDbStorageEngine.this.registerDataRegion((RocksDbDataRegionConfiguration)ctx.config(RocksDbDataRegionConfiguration.class));
                return CompletableFuture.completedFuture(null);
            }
        });
    }

    private void registerDataRegion(RocksDbDataRegionConfiguration dataRegionConfig) {
        RocksDbDataRegion region = new RocksDbDataRegion(dataRegionConfig);
        region.start();
        RocksDbDataRegion previousRegion = this.regions.put((String)dataRegionConfig.name().value(), region);
        assert (previousRegion == null) : (String)dataRegionConfig.name().value();
    }

    public void stop() throws StorageException {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.scheduledPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        try {
            IgniteUtils.closeAll(this.regions.values().stream().map(region -> region::stop));
        }
        catch (Exception e) {
            throw new StorageException("Error when stopping regions", (Throwable)e);
        }
    }

    public RocksDbTableStorage createMvTable(TableConfiguration tableCfg, TablesConfiguration tablesCfg) throws StorageException {
        RocksDbDataStorageView dataStorageView = (RocksDbDataStorageView)tableCfg.dataStorage().value();
        assert (dataStorageView.name().equals(ENGINE_NAME)) : dataStorageView.name();
        RocksDbDataRegion dataRegion = this.regions.get(dataStorageView.dataRegion());
        Path tablePath = this.storagePath.resolve(TABLE_DIR_PREFIX + tableCfg.tableId().value());
        try {
            Files.createDirectories(tablePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new StorageException("Failed to create table store directory for " + (String)tableCfg.name().value(), (Throwable)e);
        }
        return new RocksDbTableStorage(this, tablePath, dataRegion, tableCfg, tablesCfg);
    }

    static {
        RocksDB.loadLibrary();
    }
}

