/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.client.service;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.raft.client.Command;
import org.apache.ignite.raft.client.Peer;
import org.apache.ignite.raft.client.ReadCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public interface RaftGroupService {
    @NotNull
    public ReplicationGroupId groupId();

    public long timeout();

    public void timeout(long var1);

    @Nullable
    public Peer leader();

    @Nullable
    public List<Peer> peers();

    @Nullable
    public List<Peer> learners();

    public CompletableFuture<Void> refreshLeader();

    public CompletableFuture<IgniteBiTuple<Peer, Long>> refreshAndGetLeaderWithTerm();

    public CompletableFuture<Void> refreshMembers(boolean var1);

    public CompletableFuture<Void> addPeer(Peer var1);

    public CompletableFuture<Void> removePeer(Peer var1);

    public CompletableFuture<Void> changePeers(List<Peer> var1);

    public CompletableFuture<Void> changePeersAsync(List<Peer> var1, long var2);

    public CompletableFuture<Void> addLearners(List<Peer> var1);

    public CompletableFuture<Void> removeLearners(List<Peer> var1);

    public CompletableFuture<Void> resetLearners(List<Peer> var1);

    public CompletableFuture<Void> snapshot(Peer var1);

    public CompletableFuture<Void> transferLeadership(Peer var1);

    public <R> CompletableFuture<R> run(Command var1);

    public <R> CompletableFuture<R> run(Peer var1, ReadCommand var2);

    public void shutdown();

    @TestOnly
    public ClusterService clusterService();
}

